// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateNatGatewayRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Public NAT gateways only&#93; The allocation ID of an Elastic IP address to associate
     * with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway.
     * If the Elastic IP address is associated with another resource, you must first disassociate it.
     */
    val allocationId: String? = builder.allocationId
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     * idempotency.
     * Constraint: Maximum 64 ASCII characters.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Indicates whether the NAT gateway supports public or private connectivity.
     * The default is public connectivity.
     */
    val connectivityType: ConnectivityType? = builder.connectivityType
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The subnet in which to create the NAT gateway.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The tags to assign to the NAT gateway.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateNatGatewayRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNatGatewayRequest(")
        append("allocationId=$allocationId,")
        append("clientToken=$clientToken,")
        append("connectivityType=$connectivityType,")
        append("dryRun=$dryRun,")
        append("subnetId=$subnetId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (connectivityType?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateNatGatewayRequest

        if (allocationId != other.allocationId) return false
        if (clientToken != other.clientToken) return false
        if (connectivityType != other.connectivityType) return false
        if (dryRun != other.dryRun) return false
        if (subnetId != other.subnetId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateNatGatewayRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateNatGatewayRequest
        /**
         * &#91;Public NAT gateways only&#93; The allocation ID of an Elastic IP address to associate
         * with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway.
         * If the Elastic IP address is associated with another resource, you must first disassociate it.
         */
        fun allocationId(allocationId: String): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         * Constraint: Maximum 64 ASCII characters.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Indicates whether the NAT gateway supports public or private connectivity.
         * The default is public connectivity.
         */
        fun connectivityType(connectivityType: ConnectivityType): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The subnet in which to create the NAT gateway.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The tags to assign to the NAT gateway.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Public NAT gateways only&#93; The allocation ID of an Elastic IP address to associate
         * with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway.
         * If the Elastic IP address is associated with another resource, you must first disassociate it.
         */
        var allocationId: String?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         * Constraint: Maximum 64 ASCII characters.
         */
        var clientToken: String?
        /**
         * Indicates whether the NAT gateway supports public or private connectivity.
         * The default is public connectivity.
         */
        var connectivityType: ConnectivityType?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The subnet in which to create the NAT gateway.
         */
        var subnetId: String?
        /**
         * The tags to assign to the NAT gateway.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateNatGatewayRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationId: String? = null
        override var clientToken: String? = null
        override var connectivityType: ConnectivityType? = null
        override var dryRun: Boolean? = null
        override var subnetId: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateNatGatewayRequest) : this() {
            this.allocationId = x.allocationId
            this.clientToken = x.clientToken
            this.connectivityType = x.connectivityType
            this.dryRun = x.dryRun
            this.subnetId = x.subnetId
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateNatGatewayRequest = CreateNatGatewayRequest(this)
        override fun allocationId(allocationId: String): FluentBuilder = apply { this.allocationId = allocationId }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun connectivityType(connectivityType: ConnectivityType): FluentBuilder = apply { this.connectivityType = connectivityType }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
