// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateNetworkAclEntryRequest private constructor(builder: BuilderImpl) {
    /**
     * The IPv4 network range to allow or deny, in CIDR notation (for example
     * 172.16.0.0/24). We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
     */
    val cidrBlock: String? = builder.cidrBlock
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
     */
    val egress: Boolean? = builder.egress
    /**
     * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol
     * 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
     */
    val icmpTypeCode: IcmpTypeCode? = builder.icmpTypeCode
    /**
     * The IPv6 network range to allow or deny, in CIDR notation (for example
     * 2001:db8:1234:1a00::/64).
     */
    val ipv6CidrBlock: String? = builder.ipv6CidrBlock
    /**
     * The ID of the network ACL.
     */
    val networkAclId: String? = builder.networkAclId
    /**
     * TCP or UDP protocols: The range of ports the rule applies to.
     * Required if specifying protocol 6 (TCP) or 17 (UDP).
     */
    val portRange: PortRange? = builder.portRange
    /**
     * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a
     * protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is
     * allowed, regardless of any ports or ICMP types or codes that you specify. If you specify
     * protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and
     * codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6)
     * and specify an IPv6 CIDR block, you must specify an ICMP type and code.
     */
    val protocol: String? = builder.protocol
    /**
     * Indicates whether to allow or deny the traffic that matches the rule.
     */
    val ruleAction: RuleAction? = builder.ruleAction
    /**
     * The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
     * Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
     */
    val ruleNumber: Int? = builder.ruleNumber

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateNetworkAclEntryRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNetworkAclEntryRequest(")
        append("cidrBlock=$cidrBlock,")
        append("dryRun=$dryRun,")
        append("egress=$egress,")
        append("icmpTypeCode=$icmpTypeCode,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("networkAclId=$networkAclId,")
        append("portRange=$portRange,")
        append("protocol=$protocol,")
        append("ruleAction=$ruleAction,")
        append("ruleNumber=$ruleNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrBlock?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (egress?.hashCode() ?: 0)
        result = 31 * result + (icmpTypeCode?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (networkAclId?.hashCode() ?: 0)
        result = 31 * result + (portRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (ruleAction?.hashCode() ?: 0)
        result = 31 * result + (ruleNumber ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateNetworkAclEntryRequest

        if (cidrBlock != other.cidrBlock) return false
        if (dryRun != other.dryRun) return false
        if (egress != other.egress) return false
        if (icmpTypeCode != other.icmpTypeCode) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (networkAclId != other.networkAclId) return false
        if (portRange != other.portRange) return false
        if (protocol != other.protocol) return false
        if (ruleAction != other.ruleAction) return false
        if (ruleNumber != other.ruleNumber) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateNetworkAclEntryRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateNetworkAclEntryRequest
        /**
         * The IPv4 network range to allow or deny, in CIDR notation (for example
         * 172.16.0.0/24). We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
         */
        fun cidrBlock(cidrBlock: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
         */
        fun egress(egress: Boolean): FluentBuilder
        /**
         * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol
         * 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
         */
        fun icmpTypeCode(icmpTypeCode: IcmpTypeCode): FluentBuilder
        /**
         * The IPv6 network range to allow or deny, in CIDR notation (for example
         * 2001:db8:1234:1a00::/64).
         */
        fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder
        /**
         * The ID of the network ACL.
         */
        fun networkAclId(networkAclId: String): FluentBuilder
        /**
         * TCP or UDP protocols: The range of ports the rule applies to.
         * Required if specifying protocol 6 (TCP) or 17 (UDP).
         */
        fun portRange(portRange: PortRange): FluentBuilder
        /**
         * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a
         * protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is
         * allowed, regardless of any ports or ICMP types or codes that you specify. If you specify
         * protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and
         * codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6)
         * and specify an IPv6 CIDR block, you must specify an ICMP type and code.
         */
        fun protocol(protocol: String): FluentBuilder
        /**
         * Indicates whether to allow or deny the traffic that matches the rule.
         */
        fun ruleAction(ruleAction: RuleAction): FluentBuilder
        /**
         * The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
         * Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
         */
        fun ruleNumber(ruleNumber: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IPv4 network range to allow or deny, in CIDR notation (for example
         * 172.16.0.0/24). We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
         */
        var cidrBlock: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
         */
        var egress: Boolean?
        /**
         * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol
         * 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
         */
        var icmpTypeCode: IcmpTypeCode?
        /**
         * The IPv6 network range to allow or deny, in CIDR notation (for example
         * 2001:db8:1234:1a00::/64).
         */
        var ipv6CidrBlock: String?
        /**
         * The ID of the network ACL.
         */
        var networkAclId: String?
        /**
         * TCP or UDP protocols: The range of ports the rule applies to.
         * Required if specifying protocol 6 (TCP) or 17 (UDP).
         */
        var portRange: PortRange?
        /**
         * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a
         * protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is
         * allowed, regardless of any ports or ICMP types or codes that you specify. If you specify
         * protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and
         * codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6)
         * and specify an IPv6 CIDR block, you must specify an ICMP type and code.
         */
        var protocol: String?
        /**
         * Indicates whether to allow or deny the traffic that matches the rule.
         */
        var ruleAction: RuleAction?
        /**
         * The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
         * Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
         */
        var ruleNumber: Int?

        fun build(): CreateNetworkAclEntryRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IcmpTypeCode] inside the given [block]
         */
        fun icmpTypeCode(block: IcmpTypeCode.DslBuilder.() -> kotlin.Unit) {
            this.icmpTypeCode = IcmpTypeCode.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PortRange] inside the given [block]
         */
        fun portRange(block: PortRange.DslBuilder.() -> kotlin.Unit) {
            this.portRange = PortRange.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrBlock: String? = null
        override var dryRun: Boolean? = null
        override var egress: Boolean? = null
        override var icmpTypeCode: IcmpTypeCode? = null
        override var ipv6CidrBlock: String? = null
        override var networkAclId: String? = null
        override var portRange: PortRange? = null
        override var protocol: String? = null
        override var ruleAction: RuleAction? = null
        override var ruleNumber: Int? = null

        constructor(x: CreateNetworkAclEntryRequest) : this() {
            this.cidrBlock = x.cidrBlock
            this.dryRun = x.dryRun
            this.egress = x.egress
            this.icmpTypeCode = x.icmpTypeCode
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.networkAclId = x.networkAclId
            this.portRange = x.portRange
            this.protocol = x.protocol
            this.ruleAction = x.ruleAction
            this.ruleNumber = x.ruleNumber
        }

        override fun build(): CreateNetworkAclEntryRequest = CreateNetworkAclEntryRequest(this)
        override fun cidrBlock(cidrBlock: String): FluentBuilder = apply { this.cidrBlock = cidrBlock }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun egress(egress: Boolean): FluentBuilder = apply { this.egress = egress }
        override fun icmpTypeCode(icmpTypeCode: IcmpTypeCode): FluentBuilder = apply { this.icmpTypeCode = icmpTypeCode }
        override fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder = apply { this.ipv6CidrBlock = ipv6CidrBlock }
        override fun networkAclId(networkAclId: String): FluentBuilder = apply { this.networkAclId = networkAclId }
        override fun portRange(portRange: PortRange): FluentBuilder = apply { this.portRange = portRange }
        override fun protocol(protocol: String): FluentBuilder = apply { this.protocol = protocol }
        override fun ruleAction(ruleAction: RuleAction): FluentBuilder = apply { this.ruleAction = ruleAction }
        override fun ruleNumber(ruleNumber: Int): FluentBuilder = apply { this.ruleNumber = ruleNumber }
    }
}
