// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateNetworkInsightsPathRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The Amazon Web Services resource that is the destination of the path.
     */
    val destination: String? = builder.destination
    /**
     * The IP address of the Amazon Web Services resource that is the destination of the path.
     */
    val destinationIp: String? = builder.destinationIp
    /**
     * The destination port.
     */
    val destinationPort: Int? = builder.destinationPort
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The protocol.
     */
    val protocol: Protocol? = builder.protocol
    /**
     * The Amazon Web Services resource that is the source of the path.
     */
    val source: String? = builder.source
    /**
     * The IP address of the Amazon Web Services resource that is the source of the path.
     */
    val sourceIp: String? = builder.sourceIp
    /**
     * The tags to add to the path.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateNetworkInsightsPathRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNetworkInsightsPathRequest(")
        append("clientToken=$clientToken,")
        append("destination=$destination,")
        append("destinationIp=$destinationIp,")
        append("destinationPort=$destinationPort,")
        append("dryRun=$dryRun,")
        append("protocol=$protocol,")
        append("source=$source,")
        append("sourceIp=$sourceIp,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (destinationIp?.hashCode() ?: 0)
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceIp?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateNetworkInsightsPathRequest

        if (clientToken != other.clientToken) return false
        if (destination != other.destination) return false
        if (destinationIp != other.destinationIp) return false
        if (destinationPort != other.destinationPort) return false
        if (dryRun != other.dryRun) return false
        if (protocol != other.protocol) return false
        if (source != other.source) return false
        if (sourceIp != other.sourceIp) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateNetworkInsightsPathRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateNetworkInsightsPathRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The Amazon Web Services resource that is the destination of the path.
         */
        fun destination(destination: String): FluentBuilder
        /**
         * The IP address of the Amazon Web Services resource that is the destination of the path.
         */
        fun destinationIp(destinationIp: String): FluentBuilder
        /**
         * The destination port.
         */
        fun destinationPort(destinationPort: Int): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The protocol.
         */
        fun protocol(protocol: Protocol): FluentBuilder
        /**
         * The Amazon Web Services resource that is the source of the path.
         */
        fun source(source: String): FluentBuilder
        /**
         * The IP address of the Amazon Web Services resource that is the source of the path.
         */
        fun sourceIp(sourceIp: String): FluentBuilder
        /**
         * The tags to add to the path.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        var clientToken: String?
        /**
         * The Amazon Web Services resource that is the destination of the path.
         */
        var destination: String?
        /**
         * The IP address of the Amazon Web Services resource that is the destination of the path.
         */
        var destinationIp: String?
        /**
         * The destination port.
         */
        var destinationPort: Int?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The protocol.
         */
        var protocol: Protocol?
        /**
         * The Amazon Web Services resource that is the source of the path.
         */
        var source: String?
        /**
         * The IP address of the Amazon Web Services resource that is the source of the path.
         */
        var sourceIp: String?
        /**
         * The tags to add to the path.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateNetworkInsightsPathRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var destination: String? = null
        override var destinationIp: String? = null
        override var destinationPort: Int? = null
        override var dryRun: Boolean? = null
        override var protocol: Protocol? = null
        override var source: String? = null
        override var sourceIp: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateNetworkInsightsPathRequest) : this() {
            this.clientToken = x.clientToken
            this.destination = x.destination
            this.destinationIp = x.destinationIp
            this.destinationPort = x.destinationPort
            this.dryRun = x.dryRun
            this.protocol = x.protocol
            this.source = x.source
            this.sourceIp = x.sourceIp
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateNetworkInsightsPathRequest = CreateNetworkInsightsPathRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun destination(destination: String): FluentBuilder = apply { this.destination = destination }
        override fun destinationIp(destinationIp: String): FluentBuilder = apply { this.destinationIp = destinationIp }
        override fun destinationPort(destinationPort: Int): FluentBuilder = apply { this.destinationPort = destinationPort }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun protocol(protocol: Protocol): FluentBuilder = apply { this.protocol = protocol }
        override fun source(source: String): FluentBuilder = apply { this.source = source }
        override fun sourceIp(sourceIp: String): FluentBuilder = apply { this.sourceIp = sourceIp }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
