// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CreateNetworkInterfacePermission.
 */
class CreateNetworkInterfacePermissionRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services account ID.
     */
    val awsAccountId: String? = builder.awsAccountId
    /**
     * The Amazon Web Service. Currently not supported.
     */
    val awsService: String? = builder.awsService
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The type of permission to grant.
     */
    val permission: InterfacePermissionType? = builder.permission

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateNetworkInterfacePermissionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNetworkInterfacePermissionRequest(")
        append("awsAccountId=$awsAccountId,")
        append("awsService=$awsService,")
        append("dryRun=$dryRun,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("permission=$permission)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsService?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (permission?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateNetworkInterfacePermissionRequest

        if (awsAccountId != other.awsAccountId) return false
        if (awsService != other.awsService) return false
        if (dryRun != other.dryRun) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (permission != other.permission) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateNetworkInterfacePermissionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateNetworkInterfacePermissionRequest
        /**
         * The Amazon Web Services account ID.
         */
        fun awsAccountId(awsAccountId: String): FluentBuilder
        /**
         * The Amazon Web Service. Currently not supported.
         */
        fun awsService(awsService: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The type of permission to grant.
         */
        fun permission(permission: InterfacePermissionType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services account ID.
         */
        var awsAccountId: String?
        /**
         * The Amazon Web Service. Currently not supported.
         */
        var awsService: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * The type of permission to grant.
         */
        var permission: InterfacePermissionType?

        fun build(): CreateNetworkInterfacePermissionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsAccountId: String? = null
        override var awsService: String? = null
        override var dryRun: Boolean? = null
        override var networkInterfaceId: String? = null
        override var permission: InterfacePermissionType? = null

        constructor(x: CreateNetworkInterfacePermissionRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsService = x.awsService
            this.dryRun = x.dryRun
            this.networkInterfaceId = x.networkInterfaceId
            this.permission = x.permission
        }

        override fun build(): CreateNetworkInterfacePermissionRequest = CreateNetworkInterfacePermissionRequest(this)
        override fun awsAccountId(awsAccountId: String): FluentBuilder = apply { this.awsAccountId = awsAccountId }
        override fun awsService(awsService: String): FluentBuilder = apply { this.awsService = awsService }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun permission(permission: InterfacePermissionType): FluentBuilder = apply { this.permission = permission }
    }
}
