// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CreateNetworkInterface.
 */
class CreateNetworkInterfaceRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A description for the network interface.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The IDs of one or more security groups.
     */
    val groups: List<String>? = builder.groups
    /**
     * Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify
     * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">
     * Elastic Fabric Adapter in the Amazon Elastic Compute Cloud User Guide. To create a trunk network interface, specify
     * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/eni-trunking.html">
     * Network interface trunking in the Amazon Elastic Compute Cloud User Guide.
     */
    val interfaceType: NetworkInterfaceCreationType? = builder.interfaceType
    /**
     * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option.
     */
    val ipv4PrefixCount: Int? = builder.ipv4PrefixCount
    /**
     * One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option.
     */
    val ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>? = builder.ipv4Prefixes
    /**
     * The number of IPv6 addresses to assign to a network interface. Amazon EC2
     * automatically selects the IPv6 addresses from the subnet range. You can't use this
     * option if specifying specific IPv6 addresses. If your subnet has the AssignIpv6AddressOnCreation attribute set
     * to true, you can specify 0 to override this setting.
     */
    val ipv6AddressCount: Int? = builder.ipv6AddressCount
    /**
     * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
     * You can't use this option if you're specifying a number of IPv6 addresses.
     */
    val ipv6Addresses: List<InstanceIpv6Address>? = builder.ipv6Addresses
    /**
     * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv6Prefixes option.
     */
    val ipv6PrefixCount: Int? = builder.ipv6PrefixCount
    /**
     * One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the Ipv6PrefixCount option.
     */
    val ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>? = builder.ipv6Prefixes
    /**
     * The primary private IPv4 address of the network interface. If you don't specify an
     * IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you
     * specify an IP address, you cannot indicate any IP addresses specified in
     * privateIpAddresses as primary (only one IP address can be designated as
     * primary).
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * One or more private IPv4 addresses.
     */
    val privateIpAddresses: List<PrivateIpAddressSpecification>? = builder.privateIpAddresses
    /**
     * The number of secondary private IPv4 addresses to assign to a network interface. When
     * you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses
     * within the subnet's IPv4 CIDR range. You can't specify this option and specify more than
     * one private IP address using privateIpAddresses.
     * The number of IP addresses you can assign to a network interface varies by instance
     * type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per
     * Instance Type in the Amazon Virtual Private Cloud User Guide.
     */
    val secondaryPrivateIpAddressCount: Int? = builder.secondaryPrivateIpAddressCount
    /**
     * The ID of the subnet to associate with the network interface.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The tags to apply to the new network interface.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateNetworkInterfaceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNetworkInterfaceRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4PrefixCount=$ipv4PrefixCount,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6PrefixCount=$ipv6PrefixCount,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount,")
        append("subnetId=$subnetId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4PrefixCount ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6PrefixCount ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateNetworkInterfaceRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4PrefixCount != other.ipv4PrefixCount) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6PrefixCount != other.ipv6PrefixCount) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false
        if (subnetId != other.subnetId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateNetworkInterfaceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateNetworkInterfaceRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A description for the network interface.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The IDs of one or more security groups.
         */
        fun groups(groups: List<String>): FluentBuilder
        /**
         * Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify
         * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">
         * Elastic Fabric Adapter in the Amazon Elastic Compute Cloud User Guide. To create a trunk network interface, specify
         * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/eni-trunking.html">
         * Network interface trunking in the Amazon Elastic Compute Cloud User Guide.
         */
        fun interfaceType(interfaceType: NetworkInterfaceCreationType): FluentBuilder
        /**
         * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option.
         */
        fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder
        /**
         * One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option.
         */
        fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>): FluentBuilder
        /**
         * The number of IPv6 addresses to assign to a network interface. Amazon EC2
         * automatically selects the IPv6 addresses from the subnet range. You can't use this
         * option if specifying specific IPv6 addresses. If your subnet has the AssignIpv6AddressOnCreation attribute set
         * to true, you can specify 0 to override this setting.
         */
        fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder
        /**
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
         * You can't use this option if you're specifying a number of IPv6 addresses.
         */
        fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder
        /**
         * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv6Prefixes option.
         */
        fun ipv6PrefixCount(ipv6PrefixCount: Int): FluentBuilder
        /**
         * One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the Ipv6PrefixCount option.
         */
        fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>): FluentBuilder
        /**
         * The primary private IPv4 address of the network interface. If you don't specify an
         * IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you
         * specify an IP address, you cannot indicate any IP addresses specified in
         * privateIpAddresses as primary (only one IP address can be designated as
         * primary).
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * One or more private IPv4 addresses.
         */
        fun privateIpAddresses(privateIpAddresses: List<PrivateIpAddressSpecification>): FluentBuilder
        /**
         * The number of secondary private IPv4 addresses to assign to a network interface. When
         * you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses
         * within the subnet's IPv4 CIDR range. You can't specify this option and specify more than
         * one private IP address using privateIpAddresses.
         * The number of IP addresses you can assign to a network interface varies by instance
         * type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per
         * Instance Type in the Amazon Virtual Private Cloud User Guide.
         */
        fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder
        /**
         * The ID of the subnet to associate with the network interface.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The tags to apply to the new network interface.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * A description for the network interface.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The IDs of one or more security groups.
         */
        var groups: List<String>?
        /**
         * Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify
         * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">
         * Elastic Fabric Adapter in the Amazon Elastic Compute Cloud User Guide. To create a trunk network interface, specify
         * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/eni-trunking.html">
         * Network interface trunking in the Amazon Elastic Compute Cloud User Guide.
         */
        var interfaceType: NetworkInterfaceCreationType?
        /**
         * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option.
         */
        var ipv4PrefixCount: Int?
        /**
         * One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option.
         */
        var ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>?
        /**
         * The number of IPv6 addresses to assign to a network interface. Amazon EC2
         * automatically selects the IPv6 addresses from the subnet range. You can't use this
         * option if specifying specific IPv6 addresses. If your subnet has the AssignIpv6AddressOnCreation attribute set
         * to true, you can specify 0 to override this setting.
         */
        var ipv6AddressCount: Int?
        /**
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet.
         * You can't use this option if you're specifying a number of IPv6 addresses.
         */
        var ipv6Addresses: List<InstanceIpv6Address>?
        /**
         * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv6Prefixes option.
         */
        var ipv6PrefixCount: Int?
        /**
         * One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the Ipv6PrefixCount option.
         */
        var ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>?
        /**
         * The primary private IPv4 address of the network interface. If you don't specify an
         * IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you
         * specify an IP address, you cannot indicate any IP addresses specified in
         * privateIpAddresses as primary (only one IP address can be designated as
         * primary).
         */
        var privateIpAddress: String?
        /**
         * One or more private IPv4 addresses.
         */
        var privateIpAddresses: List<PrivateIpAddressSpecification>?
        /**
         * The number of secondary private IPv4 addresses to assign to a network interface. When
         * you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses
         * within the subnet's IPv4 CIDR range. You can't specify this option and specify more than
         * one private IP address using privateIpAddresses.
         * The number of IP addresses you can assign to a network interface varies by instance
         * type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per
         * Instance Type in the Amazon Virtual Private Cloud User Guide.
         */
        var secondaryPrivateIpAddressCount: Int?
        /**
         * The ID of the subnet to associate with the network interface.
         */
        var subnetId: String?
        /**
         * The tags to apply to the new network interface.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateNetworkInterfaceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var groups: List<String>? = null
        override var interfaceType: NetworkInterfaceCreationType? = null
        override var ipv4PrefixCount: Int? = null
        override var ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>? = null
        override var ipv6AddressCount: Int? = null
        override var ipv6Addresses: List<InstanceIpv6Address>? = null
        override var ipv6PrefixCount: Int? = null
        override var ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>? = null
        override var privateIpAddress: String? = null
        override var privateIpAddresses: List<PrivateIpAddressSpecification>? = null
        override var secondaryPrivateIpAddressCount: Int? = null
        override var subnetId: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateNetworkInterfaceRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.dryRun = x.dryRun
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4PrefixCount = x.ipv4PrefixCount
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6PrefixCount = x.ipv6PrefixCount
            this.ipv6Prefixes = x.ipv6Prefixes
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
            this.subnetId = x.subnetId
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateNetworkInterfaceRequest = CreateNetworkInterfaceRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun groups(groups: List<String>): FluentBuilder = apply { this.groups = groups }
        override fun interfaceType(interfaceType: NetworkInterfaceCreationType): FluentBuilder = apply { this.interfaceType = interfaceType }
        override fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder = apply { this.ipv4PrefixCount = ipv4PrefixCount }
        override fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>): FluentBuilder = apply { this.ipv4Prefixes = ipv4Prefixes }
        override fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder = apply { this.ipv6AddressCount = ipv6AddressCount }
        override fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder = apply { this.ipv6Addresses = ipv6Addresses }
        override fun ipv6PrefixCount(ipv6PrefixCount: Int): FluentBuilder = apply { this.ipv6PrefixCount = ipv6PrefixCount }
        override fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>): FluentBuilder = apply { this.ipv6Prefixes = ipv6Prefixes }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun privateIpAddresses(privateIpAddresses: List<PrivateIpAddressSpecification>): FluentBuilder = apply { this.privateIpAddresses = privateIpAddresses }
        override fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder = apply { this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
