// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CreateReservedInstancesListing.
 */
class CreateReservedInstancesListingRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier you provide to ensure idempotency of your
     * listings. This helps avoid duplicate listings. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.
     */
    val instanceCount: Int? = builder.instanceCount
    /**
     * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.
     */
    val priceSchedules: List<PriceScheduleSpecification>? = builder.priceSchedules
    /**
     * The ID of the active Standard Reserved Instance.
     */
    val reservedInstancesId: String? = builder.reservedInstancesId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateReservedInstancesListingRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateReservedInstancesListingRequest(")
        append("clientToken=$clientToken,")
        append("instanceCount=$instanceCount,")
        append("priceSchedules=$priceSchedules,")
        append("reservedInstancesId=$reservedInstancesId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (priceSchedules?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateReservedInstancesListingRequest

        if (clientToken != other.clientToken) return false
        if (instanceCount != other.instanceCount) return false
        if (priceSchedules != other.priceSchedules) return false
        if (reservedInstancesId != other.reservedInstancesId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateReservedInstancesListingRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateReservedInstancesListingRequest
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of your
         * listings. This helps avoid duplicate listings. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
        /**
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.
         */
        fun priceSchedules(priceSchedules: List<PriceScheduleSpecification>): FluentBuilder
        /**
         * The ID of the active Standard Reserved Instance.
         */
        fun reservedInstancesId(reservedInstancesId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier you provide to ensure idempotency of your
         * listings. This helps avoid duplicate listings. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.
         */
        var instanceCount: Int?
        /**
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.
         */
        var priceSchedules: List<PriceScheduleSpecification>?
        /**
         * The ID of the active Standard Reserved Instance.
         */
        var reservedInstancesId: String?

        fun build(): CreateReservedInstancesListingRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var instanceCount: Int? = null
        override var priceSchedules: List<PriceScheduleSpecification>? = null
        override var reservedInstancesId: String? = null

        constructor(x: CreateReservedInstancesListingRequest) : this() {
            this.clientToken = x.clientToken
            this.instanceCount = x.instanceCount
            this.priceSchedules = x.priceSchedules
            this.reservedInstancesId = x.reservedInstancesId
        }

        override fun build(): CreateReservedInstancesListingRequest = CreateReservedInstancesListingRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
        override fun priceSchedules(priceSchedules: List<PriceScheduleSpecification>): FluentBuilder = apply { this.priceSchedules = priceSchedules }
        override fun reservedInstancesId(reservedInstancesId: String): FluentBuilder = apply { this.reservedInstancesId = reservedInstancesId }
    }
}
