// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateRestoreImageTaskRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the Amazon S3 bucket that contains the stored AMI object.
     */
    val bucket: String? = builder.bucket
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The name for the restored AMI. The name must be unique for AMIs in the Region for this
     * account. If you do not provide a name, the new AMI gets the same name as the original
     * AMI.
     */
    val name: String? = builder.name
    /**
     * The name of the stored AMI object in the bucket.
     */
    val objectKey: String? = builder.objectKey
    /**
     * The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the
     * snapshots, or both.
     * To tag the AMI, the value for ResourceType must be image.
     * To
     * tag the snapshots, the value for ResourceType must be snapshot. The
     * same tag is applied to all of the snapshots that are created.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateRestoreImageTaskRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRestoreImageTaskRequest(")
        append("bucket=$bucket,")
        append("dryRun=$dryRun,")
        append("name=$name,")
        append("objectKey=$objectKey,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (objectKey?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateRestoreImageTaskRequest

        if (bucket != other.bucket) return false
        if (dryRun != other.dryRun) return false
        if (name != other.name) return false
        if (objectKey != other.objectKey) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateRestoreImageTaskRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateRestoreImageTaskRequest
        /**
         * The name of the Amazon S3 bucket that contains the stored AMI object.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The name for the restored AMI. The name must be unique for AMIs in the Region for this
         * account. If you do not provide a name, the new AMI gets the same name as the original
         * AMI.
         */
        fun name(name: String): FluentBuilder
        /**
         * The name of the stored AMI object in the bucket.
         */
        fun objectKey(objectKey: String): FluentBuilder
        /**
         * The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the
         * snapshots, or both.
         * To tag the AMI, the value for ResourceType must be image.
         * To
         * tag the snapshots, the value for ResourceType must be snapshot. The
         * same tag is applied to all of the snapshots that are created.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the Amazon S3 bucket that contains the stored AMI object.
         */
        var bucket: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The name for the restored AMI. The name must be unique for AMIs in the Region for this
         * account. If you do not provide a name, the new AMI gets the same name as the original
         * AMI.
         */
        var name: String?
        /**
         * The name of the stored AMI object in the bucket.
         */
        var objectKey: String?
        /**
         * The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the
         * snapshots, or both.
         * To tag the AMI, the value for ResourceType must be image.
         * To
         * tag the snapshots, the value for ResourceType must be snapshot. The
         * same tag is applied to all of the snapshots that are created.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateRestoreImageTaskRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var dryRun: Boolean? = null
        override var name: String? = null
        override var objectKey: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateRestoreImageTaskRequest) : this() {
            this.bucket = x.bucket
            this.dryRun = x.dryRun
            this.name = x.name
            this.objectKey = x.objectKey
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateRestoreImageTaskRequest = CreateRestoreImageTaskRequest(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun objectKey(objectKey: String): FluentBuilder = apply { this.objectKey = objectKey }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
