// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateSecurityGroupRequest private constructor(builder: BuilderImpl) {
    /**
     * A description for the security group. This is informational only.
     * Constraints: Up to 255 characters in length
     * Constraints for EC2-Classic: ASCII characters
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The name of the security group.
     * Constraints: Up to 255 characters in length. Cannot start with
     * sg-.
     * Constraints for EC2-Classic: ASCII characters
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
     */
    val groupName: String? = builder.groupName
    /**
     * The tags to assign to the security group.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * &#91;EC2-VPC&#93; The ID of the VPC. Required for EC2-VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSecurityGroupRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSecurityGroupRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("groupName=$groupName,")
        append("tagSpecifications=$tagSpecifications,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSecurityGroupRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (groupName != other.groupName) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSecurityGroupRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSecurityGroupRequest
        /**
         * A description for the security group. This is informational only.
         * Constraints: Up to 255 characters in length
         * Constraints for EC2-Classic: ASCII characters
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The name of the security group.
         * Constraints: Up to 255 characters in length. Cannot start with
         * sg-.
         * Constraints for EC2-Classic: ASCII characters
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The tags to assign to the security group.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; The ID of the VPC. Required for EC2-VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description for the security group. This is informational only.
         * Constraints: Up to 255 characters in length
         * Constraints for EC2-Classic: ASCII characters
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The name of the security group.
         * Constraints: Up to 255 characters in length. Cannot start with
         * sg-.
         * Constraints for EC2-Classic: ASCII characters
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@&#91;&#93;+=&;{}!$*
         */
        var groupName: String?
        /**
         * The tags to assign to the security group.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * &#91;EC2-VPC&#93; The ID of the VPC. Required for EC2-VPC.
         */
        var vpcId: String?

        fun build(): CreateSecurityGroupRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var groupName: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var vpcId: String? = null

        constructor(x: CreateSecurityGroupRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.groupName = x.groupName
            this.tagSpecifications = x.tagSpecifications
            this.vpcId = x.vpcId
        }

        override fun build(): CreateSecurityGroupRequest = CreateSecurityGroupRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
