// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateSnapshotRequest private constructor(builder: BuilderImpl) {
    /**
     * A description for the snapshot.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local
     * snapshot.
     * To create a snapshot of a volume in a Region, omit this parameter. The snapshot
     * is created in the same Region as the volume.
     * To create a snapshot of a volume on an Outpost and store the snapshot in the
     * Region, omit this parameter. The snapshot is created in the Region for the
     * Outpost.
     * To create a snapshot of a volume on an Outpost and store the snapshot on an
     * Outpost, specify the ARN of the destination Outpost. The snapshot must be created on
     * the same Outpost as the volume.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost in the Amazon Elastic Compute Cloud User Guide.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The tags to apply to the snapshot during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The ID of the Amazon EBS volume.
     */
    val volumeId: String? = builder.volumeId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSnapshotRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("outpostArn=$outpostArn,")
        append("tagSpecifications=$tagSpecifications,")
        append("volumeId=$volumeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSnapshotRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (outpostArn != other.outpostArn) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (volumeId != other.volumeId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSnapshotRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSnapshotRequest
        /**
         * A description for the snapshot.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create a local
         * snapshot.
         * To create a snapshot of a volume in a Region, omit this parameter. The snapshot
         * is created in the same Region as the volume.
         * To create a snapshot of a volume on an Outpost and store the snapshot in the
         * Region, omit this parameter. The snapshot is created in the Region for the
         * Outpost.
         * To create a snapshot of a volume on an Outpost and store the snapshot on an
         * Outpost, specify the ARN of the destination Outpost. The snapshot must be created on
         * the same Outpost as the volume.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost in the Amazon Elastic Compute Cloud User Guide.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The tags to apply to the snapshot during creation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The ID of the Amazon EBS volume.
         */
        fun volumeId(volumeId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description for the snapshot.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create a local
         * snapshot.
         * To create a snapshot of a volume in a Region, omit this parameter. The snapshot
         * is created in the same Region as the volume.
         * To create a snapshot of a volume on an Outpost and store the snapshot in the
         * Region, omit this parameter. The snapshot is created in the Region for the
         * Outpost.
         * To create a snapshot of a volume on an Outpost and store the snapshot on an
         * Outpost, specify the ARN of the destination Outpost. The snapshot must be created on
         * the same Outpost as the volume.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost in the Amazon Elastic Compute Cloud User Guide.
         */
        var outpostArn: String?
        /**
         * The tags to apply to the snapshot during creation.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The ID of the Amazon EBS volume.
         */
        var volumeId: String?

        fun build(): CreateSnapshotRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var outpostArn: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var volumeId: String? = null

        constructor(x: CreateSnapshotRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.outpostArn = x.outpostArn
            this.tagSpecifications = x.tagSpecifications
            this.volumeId = x.volumeId
        }

        override fun build(): CreateSnapshotRequest = CreateSnapshotRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
    }
}
