// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a snapshot.
 */
class CreateSnapshotResponse private constructor(builder: BuilderImpl) {
    /**
     * The data encryption key identifier for the snapshot. This value is a unique identifier
     * that corresponds to the data encryption key that was used to encrypt the original volume or
     * snapshot copy. Because data encryption keys are inherited by volumes created from snapshots,
     * and vice versa, if snapshots share the same data encryption key identifier, then they belong
     * to the same volume/snapshot lineage. This parameter is only returned by DescribeSnapshots.
     */
    val dataEncryptionKeyId: String? = builder.dataEncryptionKeyId
    /**
     * The description for the snapshot.
     */
    val description: String? = builder.description
    /**
     * Indicates whether the snapshot is encrypted.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
     * volume encryption key for the parent volume.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The Amazon Web Services owner alias, from an Amazon-maintained list (amazon). This is not
     * the user-configured Amazon Web Services account alias set using the IAM console.
     */
    val ownerAlias: String? = builder.ownerAlias
    /**
     * The ID of the Amazon Web Services account that owns the EBS snapshot.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The progress of the snapshot, as a percentage.
     */
    val progress: String? = builder.progress
    /**
     * The ID of the snapshot. Each snapshot receives a unique identifier when it is
     * created.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * The time stamp when the snapshot was initiated.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The snapshot state.
     */
    val state: SnapshotState? = builder.state
    /**
     * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails
     * (for example, if the proper Key Management Service (KMS) permissions are not obtained) this field displays error
     * state details to help you diagnose why the error occurred. This parameter is only returned by
     * DescribeSnapshots.
     */
    val stateMessage: String? = builder.stateMessage
    /**
     * Any tags assigned to the snapshot.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the volume that was used to create the snapshot. Snapshots created by the CopySnapshot action have an arbitrary volume ID that should not be used for any
     * purpose.
     */
    val volumeId: String? = builder.volumeId
    /**
     * The size of the volume, in GiB.
     */
    val volumeSize: Int? = builder.volumeSize

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSnapshotResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotResponse(")
        append("dataEncryptionKeyId=$dataEncryptionKeyId,")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("outpostArn=$outpostArn,")
        append("ownerAlias=$ownerAlias,")
        append("ownerId=$ownerId,")
        append("progress=$progress,")
        append("snapshotId=$snapshotId,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("stateMessage=$stateMessage,")
        append("tags=$tags,")
        append("volumeId=$volumeId,")
        append("volumeSize=$volumeSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataEncryptionKeyId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerAlias?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSnapshotResponse

        if (dataEncryptionKeyId != other.dataEncryptionKeyId) return false
        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerAlias != other.ownerAlias) return false
        if (ownerId != other.ownerId) return false
        if (progress != other.progress) return false
        if (snapshotId != other.snapshotId) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (stateMessage != other.stateMessage) return false
        if (tags != other.tags) return false
        if (volumeId != other.volumeId) return false
        if (volumeSize != other.volumeSize) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSnapshotResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSnapshotResponse
        /**
         * The data encryption key identifier for the snapshot. This value is a unique identifier
         * that corresponds to the data encryption key that was used to encrypt the original volume or
         * snapshot copy. Because data encryption keys are inherited by volumes created from snapshots,
         * and vice versa, if snapshots share the same data encryption key identifier, then they belong
         * to the same volume/snapshot lineage. This parameter is only returned by DescribeSnapshots.
         */
        fun dataEncryptionKeyId(dataEncryptionKeyId: String): FluentBuilder
        /**
         * The description for the snapshot.
         */
        fun description(description: String): FluentBuilder
        /**
         * Indicates whether the snapshot is encrypted.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
         * volume encryption key for the parent volume.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The Amazon Web Services owner alias, from an Amazon-maintained list (amazon). This is not
         * the user-configured Amazon Web Services account alias set using the IAM console.
         */
        fun ownerAlias(ownerAlias: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the EBS snapshot.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The progress of the snapshot, as a percentage.
         */
        fun progress(progress: String): FluentBuilder
        /**
         * The ID of the snapshot. Each snapshot receives a unique identifier when it is
         * created.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * The time stamp when the snapshot was initiated.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The snapshot state.
         */
        fun state(state: SnapshotState): FluentBuilder
        /**
         * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails
         * (for example, if the proper Key Management Service (KMS) permissions are not obtained) this field displays error
         * state details to help you diagnose why the error occurred. This parameter is only returned by
         * DescribeSnapshots.
         */
        fun stateMessage(stateMessage: String): FluentBuilder
        /**
         * Any tags assigned to the snapshot.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the volume that was used to create the snapshot. Snapshots created by the CopySnapshot action have an arbitrary volume ID that should not be used for any
         * purpose.
         */
        fun volumeId(volumeId: String): FluentBuilder
        /**
         * The size of the volume, in GiB.
         */
        fun volumeSize(volumeSize: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The data encryption key identifier for the snapshot. This value is a unique identifier
         * that corresponds to the data encryption key that was used to encrypt the original volume or
         * snapshot copy. Because data encryption keys are inherited by volumes created from snapshots,
         * and vice versa, if snapshots share the same data encryption key identifier, then they belong
         * to the same volume/snapshot lineage. This parameter is only returned by DescribeSnapshots.
         */
        var dataEncryptionKeyId: String?
        /**
         * The description for the snapshot.
         */
        var description: String?
        /**
         * Indicates whether the snapshot is encrypted.
         */
        var encrypted: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
         * volume encryption key for the parent volume.
         */
        var kmsKeyId: String?
        /**
         * The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var outpostArn: String?
        /**
         * The Amazon Web Services owner alias, from an Amazon-maintained list (amazon). This is not
         * the user-configured Amazon Web Services account alias set using the IAM console.
         */
        var ownerAlias: String?
        /**
         * The ID of the Amazon Web Services account that owns the EBS snapshot.
         */
        var ownerId: String?
        /**
         * The progress of the snapshot, as a percentage.
         */
        var progress: String?
        /**
         * The ID of the snapshot. Each snapshot receives a unique identifier when it is
         * created.
         */
        var snapshotId: String?
        /**
         * The time stamp when the snapshot was initiated.
         */
        var startTime: Instant?
        /**
         * The snapshot state.
         */
        var state: SnapshotState?
        /**
         * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails
         * (for example, if the proper Key Management Service (KMS) permissions are not obtained) this field displays error
         * state details to help you diagnose why the error occurred. This parameter is only returned by
         * DescribeSnapshots.
         */
        var stateMessage: String?
        /**
         * Any tags assigned to the snapshot.
         */
        var tags: List<Tag>?
        /**
         * The ID of the volume that was used to create the snapshot. Snapshots created by the CopySnapshot action have an arbitrary volume ID that should not be used for any
         * purpose.
         */
        var volumeId: String?
        /**
         * The size of the volume, in GiB.
         */
        var volumeSize: Int?

        fun build(): CreateSnapshotResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataEncryptionKeyId: String? = null
        override var description: String? = null
        override var encrypted: Boolean? = null
        override var kmsKeyId: String? = null
        override var outpostArn: String? = null
        override var ownerAlias: String? = null
        override var ownerId: String? = null
        override var progress: String? = null
        override var snapshotId: String? = null
        override var startTime: Instant? = null
        override var state: SnapshotState? = null
        override var stateMessage: String? = null
        override var tags: List<Tag>? = null
        override var volumeId: String? = null
        override var volumeSize: Int? = null

        constructor(x: CreateSnapshotResponse) : this() {
            this.dataEncryptionKeyId = x.dataEncryptionKeyId
            this.description = x.description
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.outpostArn = x.outpostArn
            this.ownerAlias = x.ownerAlias
            this.ownerId = x.ownerId
            this.progress = x.progress
            this.snapshotId = x.snapshotId
            this.startTime = x.startTime
            this.state = x.state
            this.stateMessage = x.stateMessage
            this.tags = x.tags
            this.volumeId = x.volumeId
            this.volumeSize = x.volumeSize
        }

        override fun build(): CreateSnapshotResponse = CreateSnapshotResponse(this)
        override fun dataEncryptionKeyId(dataEncryptionKeyId: String): FluentBuilder = apply { this.dataEncryptionKeyId = dataEncryptionKeyId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun ownerAlias(ownerAlias: String): FluentBuilder = apply { this.ownerAlias = ownerAlias }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun progress(progress: String): FluentBuilder = apply { this.progress = progress }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun state(state: SnapshotState): FluentBuilder = apply { this.state = state }
        override fun stateMessage(stateMessage: String): FluentBuilder = apply { this.stateMessage = stateMessage }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
        override fun volumeSize(volumeSize: Int): FluentBuilder = apply { this.volumeSize = volumeSize }
    }
}
