// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateSnapshotsRequest private constructor(builder: BuilderImpl) {
    /**
     * Copies the tags from the specified volume to corresponding snapshot.
     */
    val copyTagsFromSource: CopyTagsFromSource? = builder.copyTagsFromSource
    /**
     * A description propagated to every snapshot specified by the instance.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The instance to specify which volumes should be included in the snapshots.
     */
    val instanceSpecification: InstanceSpecification? = builder.instanceSpecification
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the local
     * snapshots.
     * To create snapshots from an instance in a Region, omit this parameter. The
     * snapshots are created in the same Region as the instance.
     * To create snapshots from an instance on an Outpost and store the snapshots
     * in the Region, omit this parameter. The snapshots are created in the Region
     * for the Outpost.
     * To create snapshots from an instance on an Outpost and store the snapshots
     * on an Outpost, specify the ARN of the destination Outpost. The snapshots must
     * be created on the same Outpost as the instance.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot">
     * Create multi-volume local snapshots from instances on an Outpost in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * Tags to apply to every snapshot specified by the instance.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSnapshotsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotsRequest(")
        append("copyTagsFromSource=$copyTagsFromSource,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("instanceSpecification=$instanceSpecification,")
        append("outpostArn=$outpostArn,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTagsFromSource?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceSpecification?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSnapshotsRequest

        if (copyTagsFromSource != other.copyTagsFromSource) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (instanceSpecification != other.instanceSpecification) return false
        if (outpostArn != other.outpostArn) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSnapshotsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSnapshotsRequest
        /**
         * Copies the tags from the specified volume to corresponding snapshot.
         */
        fun copyTagsFromSource(copyTagsFromSource: CopyTagsFromSource): FluentBuilder
        /**
         * A description propagated to every snapshot specified by the instance.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The instance to specify which volumes should be included in the snapshots.
         */
        fun instanceSpecification(instanceSpecification: InstanceSpecification): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create the local
         * snapshots.
         * To create snapshots from an instance in a Region, omit this parameter. The
         * snapshots are created in the same Region as the instance.
         * To create snapshots from an instance on an Outpost and store the snapshots
         * in the Region, omit this parameter. The snapshots are created in the Region
         * for the Outpost.
         * To create snapshots from an instance on an Outpost and store the snapshots
         * on an Outpost, specify the ARN of the destination Outpost. The snapshots must
         * be created on the same Outpost as the instance.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot">
         * Create multi-volume local snapshots from instances on an Outpost in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * Tags to apply to every snapshot specified by the instance.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Copies the tags from the specified volume to corresponding snapshot.
         */
        var copyTagsFromSource: CopyTagsFromSource?
        /**
         * A description propagated to every snapshot specified by the instance.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The instance to specify which volumes should be included in the snapshots.
         */
        var instanceSpecification: InstanceSpecification?
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create the local
         * snapshots.
         * To create snapshots from an instance in a Region, omit this parameter. The
         * snapshots are created in the same Region as the instance.
         * To create snapshots from an instance on an Outpost and store the snapshots
         * in the Region, omit this parameter. The snapshots are created in the Region
         * for the Outpost.
         * To create snapshots from an instance on an Outpost and store the snapshots
         * on an Outpost, specify the ARN of the destination Outpost. The snapshots must
         * be created on the same Outpost as the instance.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot">
         * Create multi-volume local snapshots from instances on an Outpost in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var outpostArn: String?
        /**
         * Tags to apply to every snapshot specified by the instance.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateSnapshotsRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceSpecification] inside the given [block]
         */
        fun instanceSpecification(block: InstanceSpecification.DslBuilder.() -> kotlin.Unit) {
            this.instanceSpecification = InstanceSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var copyTagsFromSource: CopyTagsFromSource? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var instanceSpecification: InstanceSpecification? = null
        override var outpostArn: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateSnapshotsRequest) : this() {
            this.copyTagsFromSource = x.copyTagsFromSource
            this.description = x.description
            this.dryRun = x.dryRun
            this.instanceSpecification = x.instanceSpecification
            this.outpostArn = x.outpostArn
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateSnapshotsRequest = CreateSnapshotsRequest(this)
        override fun copyTagsFromSource(copyTagsFromSource: CopyTagsFromSource): FluentBuilder = apply { this.copyTagsFromSource = copyTagsFromSource }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceSpecification(instanceSpecification: InstanceSpecification): FluentBuilder = apply { this.instanceSpecification = instanceSpecification }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
