// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateStoreImageTaskRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in
     * the Region in which the request is being made. The AMI object appears in the bucket only after
     * the upload task has completed.
     */
    val bucket: String? = builder.bucket
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the AMI.
     */
    val imageId: String? = builder.imageId
    /**
     * The tags to apply to the AMI object that will be stored in the Amazon S3 bucket.
     */
    val s3ObjectTags: List<S3ObjectTag>? = builder.s3ObjectTags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateStoreImageTaskRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStoreImageTaskRequest(")
        append("bucket=$bucket,")
        append("dryRun=$dryRun,")
        append("imageId=$imageId,")
        append("s3ObjectTags=$s3ObjectTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (s3ObjectTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateStoreImageTaskRequest

        if (bucket != other.bucket) return false
        if (dryRun != other.dryRun) return false
        if (imageId != other.imageId) return false
        if (s3ObjectTags != other.s3ObjectTags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateStoreImageTaskRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateStoreImageTaskRequest
        /**
         * The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in
         * the Region in which the request is being made. The AMI object appears in the bucket only after
         * the upload task has completed.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the AMI.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The tags to apply to the AMI object that will be stored in the Amazon S3 bucket.
         */
        fun s3ObjectTags(s3ObjectTags: List<S3ObjectTag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in
         * the Region in which the request is being made. The AMI object appears in the bucket only after
         * the upload task has completed.
         */
        var bucket: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the AMI.
         */
        var imageId: String?
        /**
         * The tags to apply to the AMI object that will be stored in the Amazon S3 bucket.
         */
        var s3ObjectTags: List<S3ObjectTag>?

        fun build(): CreateStoreImageTaskRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var dryRun: Boolean? = null
        override var imageId: String? = null
        override var s3ObjectTags: List<S3ObjectTag>? = null

        constructor(x: CreateStoreImageTaskRequest) : this() {
            this.bucket = x.bucket
            this.dryRun = x.dryRun
            this.imageId = x.imageId
            this.s3ObjectTags = x.s3ObjectTags
        }

        override fun build(): CreateStoreImageTaskRequest = CreateStoreImageTaskRequest(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun s3ObjectTags(s3ObjectTags: List<S3ObjectTag>): FluentBuilder = apply { this.s3ObjectTags = s3ObjectTags }
    }
}
