// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateSubnetCidrReservationRequest private constructor(builder: BuilderImpl) {
    /**
     * The IPv4 or IPV6 CIDR range to reserve.
     */
    val cidr: String? = builder.cidr
    /**
     * The
     * description
     * to assign to the subnet CIDR reservation.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The type of reservation.
     * The following are valid values:
     * prefix: The Amazon EC2
     * Prefix
     * Delegation feature assigns the IP addresses to network interfaces that are
     * associated with an instance. For information about Prefix
     * Delegation,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation
     * for Amazon EC2 network interfaces in the
     * Amazon Elastic Compute Cloud User Guide.
     * explicit: You manually assign the IP addresses to resources that
     * reside in your subnet.
     */
    val reservationType: SubnetCidrReservationType? = builder.reservationType
    /**
     * The ID of the subnet.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The tags to assign to the subnet CIDR reservation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSubnetCidrReservationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSubnetCidrReservationRequest(")
        append("cidr=$cidr,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("reservationType=$reservationType,")
        append("subnetId=$subnetId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidr?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (reservationType?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSubnetCidrReservationRequest

        if (cidr != other.cidr) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (reservationType != other.reservationType) return false
        if (subnetId != other.subnetId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSubnetCidrReservationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSubnetCidrReservationRequest
        /**
         * The IPv4 or IPV6 CIDR range to reserve.
         */
        fun cidr(cidr: String): FluentBuilder
        /**
         * The
         * description
         * to assign to the subnet CIDR reservation.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The type of reservation.
         * The following are valid values:
         * prefix: The Amazon EC2
         * Prefix
         * Delegation feature assigns the IP addresses to network interfaces that are
         * associated with an instance. For information about Prefix
         * Delegation,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation
         * for Amazon EC2 network interfaces in the
         * Amazon Elastic Compute Cloud User Guide.
         * explicit: You manually assign the IP addresses to resources that
         * reside in your subnet.
         */
        fun reservationType(reservationType: SubnetCidrReservationType): FluentBuilder
        /**
         * The ID of the subnet.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The tags to assign to the subnet CIDR reservation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IPv4 or IPV6 CIDR range to reserve.
         */
        var cidr: String?
        /**
         * The
         * description
         * to assign to the subnet CIDR reservation.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The type of reservation.
         * The following are valid values:
         * prefix: The Amazon EC2
         * Prefix
         * Delegation feature assigns the IP addresses to network interfaces that are
         * associated with an instance. For information about Prefix
         * Delegation,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation
         * for Amazon EC2 network interfaces in the
         * Amazon Elastic Compute Cloud User Guide.
         * explicit: You manually assign the IP addresses to resources that
         * reside in your subnet.
         */
        var reservationType: SubnetCidrReservationType?
        /**
         * The ID of the subnet.
         */
        var subnetId: String?
        /**
         * The tags to assign to the subnet CIDR reservation.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateSubnetCidrReservationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidr: String? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var reservationType: SubnetCidrReservationType? = null
        override var subnetId: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateSubnetCidrReservationRequest) : this() {
            this.cidr = x.cidr
            this.description = x.description
            this.dryRun = x.dryRun
            this.reservationType = x.reservationType
            this.subnetId = x.subnetId
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateSubnetCidrReservationRequest = CreateSubnetCidrReservationRequest(this)
        override fun cidr(cidr: String): FluentBuilder = apply { this.cidr = cidr }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun reservationType(reservationType: SubnetCidrReservationType): FluentBuilder = apply { this.reservationType = reservationType }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
