// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateSubnetRequest private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone or Local Zone for the subnet.
     * Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we
     * do not necessarily select a different zone for each subnet.
     * To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
     * us-west-2-lax-1a. For information about the Regions that support Local Zones,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions in the Amazon Elastic Compute Cloud User Guide.
     * To create a subnet in an Outpost, set this value to the Availability Zone for the
     * Outpost and specify the Outpost ARN.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The AZ ID or the Local Zone ID of the subnet.
     */
    val availabilityZoneId: String? = builder.availabilityZoneId
    /**
     * The IPv4 network range for the subnet, in CIDR notation. For example, 10.0.0.0/24. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
     */
    val cidrBlock: String? = builder.cidrBlock
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a
     * /64 prefix length.
     */
    val ipv6CidrBlock: String? = builder.ipv6CidrBlock
    /**
     * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also
     * specify the Availability Zone of the Outpost subnet.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The tags to assign to the subnet.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateSubnetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSubnetRequest(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("cidrBlock=$cidrBlock,")
        append("dryRun=$dryRun,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("outpostArn=$outpostArn,")
        append("tagSpecifications=$tagSpecifications,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateSubnetRequest

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (cidrBlock != other.cidrBlock) return false
        if (dryRun != other.dryRun) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (outpostArn != other.outpostArn) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateSubnetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateSubnetRequest
        /**
         * The Availability Zone or Local Zone for the subnet.
         * Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we
         * do not necessarily select a different zone for each subnet.
         * To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
         * us-west-2-lax-1a. For information about the Regions that support Local Zones,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions in the Amazon Elastic Compute Cloud User Guide.
         * To create a subnet in an Outpost, set this value to the Availability Zone for the
         * Outpost and specify the Outpost ARN.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The AZ ID or the Local Zone ID of the subnet.
         */
        fun availabilityZoneId(availabilityZoneId: String): FluentBuilder
        /**
         * The IPv4 network range for the subnet, in CIDR notation. For example, 10.0.0.0/24. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
         */
        fun cidrBlock(cidrBlock: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a
         * /64 prefix length.
         */
        fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also
         * specify the Availability Zone of the Outpost subnet.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The tags to assign to the subnet.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone or Local Zone for the subnet.
         * Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we
         * do not necessarily select a different zone for each subnet.
         * To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
         * us-west-2-lax-1a. For information about the Regions that support Local Zones,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions in the Amazon Elastic Compute Cloud User Guide.
         * To create a subnet in an Outpost, set this value to the Availability Zone for the
         * Outpost and specify the Outpost ARN.
         */
        var availabilityZone: String?
        /**
         * The AZ ID or the Local Zone ID of the subnet.
         */
        var availabilityZoneId: String?
        /**
         * The IPv4 network range for the subnet, in CIDR notation. For example, 10.0.0.0/24. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
         */
        var cidrBlock: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a
         * /64 prefix length.
         */
        var ipv6CidrBlock: String?
        /**
         * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also
         * specify the Availability Zone of the Outpost subnet.
         */
        var outpostArn: String?
        /**
         * The tags to assign to the subnet.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): CreateSubnetRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var availabilityZoneId: String? = null
        override var cidrBlock: String? = null
        override var dryRun: Boolean? = null
        override var ipv6CidrBlock: String? = null
        override var outpostArn: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var vpcId: String? = null

        constructor(x: CreateSubnetRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.cidrBlock = x.cidrBlock
            this.dryRun = x.dryRun
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.outpostArn = x.outpostArn
            this.tagSpecifications = x.tagSpecifications
            this.vpcId = x.vpcId
        }

        override fun build(): CreateSubnetRequest = CreateSubnetRequest(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneId(availabilityZoneId: String): FluentBuilder = apply { this.availabilityZoneId = availabilityZoneId }
        override fun cidrBlock(cidrBlock: String): FluentBuilder = apply { this.cidrBlock = cidrBlock }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun ipv6CidrBlock(ipv6CidrBlock: String): FluentBuilder = apply { this.ipv6CidrBlock = ipv6CidrBlock }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
