// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateTrafficMirrorFilterRuleRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The description of the Traffic Mirror rule.
     */
    val description: String? = builder.description
    /**
     * The destination CIDR block to assign to the Traffic Mirror rule.
     */
    val destinationCidrBlock: String? = builder.destinationCidrBlock
    /**
     * The destination port range.
     */
    val destinationPortRange: TrafficMirrorPortRangeRequest? = builder.destinationPortRange
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The protocol, for example UDP, to assign to the Traffic Mirror rule.
     * For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers on the  Internet Assigned Numbers Authority (IANA) website.
     */
    val protocol: Int? = builder.protocol
    /**
     * The action to take on the filtered traffic.
     */
    val ruleAction: TrafficMirrorRuleAction? = builder.ruleAction
    /**
     * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
     * direction. The rules are processed in ascending order by rule number.
     */
    val ruleNumber: Int? = builder.ruleNumber
    /**
     * The source CIDR block to assign to the Traffic Mirror rule.
     */
    val sourceCidrBlock: String? = builder.sourceCidrBlock
    /**
     * The source port range.
     */
    val sourcePortRange: TrafficMirrorPortRangeRequest? = builder.sourcePortRange
    /**
     * The type of traffic.
     */
    val trafficDirection: TrafficDirection? = builder.trafficDirection
    /**
     * The ID of the filter that this rule is associated with.
     */
    val trafficMirrorFilterId: String? = builder.trafficMirrorFilterId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateTrafficMirrorFilterRuleRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrafficMirrorFilterRuleRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("destinationPortRange=$destinationPortRange,")
        append("dryRun=$dryRun,")
        append("protocol=$protocol,")
        append("ruleAction=$ruleAction,")
        append("ruleNumber=$ruleNumber,")
        append("sourceCidrBlock=$sourceCidrBlock,")
        append("sourcePortRange=$sourcePortRange,")
        append("trafficDirection=$trafficDirection,")
        append("trafficMirrorFilterId=$trafficMirrorFilterId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationPortRange?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (protocol ?: 0)
        result = 31 * result + (ruleAction?.hashCode() ?: 0)
        result = 31 * result + (ruleNumber ?: 0)
        result = 31 * result + (sourceCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (sourcePortRange?.hashCode() ?: 0)
        result = 31 * result + (trafficDirection?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorFilterId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateTrafficMirrorFilterRuleRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (destinationPortRange != other.destinationPortRange) return false
        if (dryRun != other.dryRun) return false
        if (protocol != other.protocol) return false
        if (ruleAction != other.ruleAction) return false
        if (ruleNumber != other.ruleNumber) return false
        if (sourceCidrBlock != other.sourceCidrBlock) return false
        if (sourcePortRange != other.sourcePortRange) return false
        if (trafficDirection != other.trafficDirection) return false
        if (trafficMirrorFilterId != other.trafficMirrorFilterId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateTrafficMirrorFilterRuleRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateTrafficMirrorFilterRuleRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The description of the Traffic Mirror rule.
         */
        fun description(description: String): FluentBuilder
        /**
         * The destination CIDR block to assign to the Traffic Mirror rule.
         */
        fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder
        /**
         * The destination port range.
         */
        fun destinationPortRange(destinationPortRange: TrafficMirrorPortRangeRequest): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The protocol, for example UDP, to assign to the Traffic Mirror rule.
         * For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers on the  Internet Assigned Numbers Authority (IANA) website.
         */
        fun protocol(protocol: Int): FluentBuilder
        /**
         * The action to take on the filtered traffic.
         */
        fun ruleAction(ruleAction: TrafficMirrorRuleAction): FluentBuilder
        /**
         * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
         * direction. The rules are processed in ascending order by rule number.
         */
        fun ruleNumber(ruleNumber: Int): FluentBuilder
        /**
         * The source CIDR block to assign to the Traffic Mirror rule.
         */
        fun sourceCidrBlock(sourceCidrBlock: String): FluentBuilder
        /**
         * The source port range.
         */
        fun sourcePortRange(sourcePortRange: TrafficMirrorPortRangeRequest): FluentBuilder
        /**
         * The type of traffic.
         */
        fun trafficDirection(trafficDirection: TrafficDirection): FluentBuilder
        /**
         * The ID of the filter that this rule is associated with.
         */
        fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        var clientToken: String?
        /**
         * The description of the Traffic Mirror rule.
         */
        var description: String?
        /**
         * The destination CIDR block to assign to the Traffic Mirror rule.
         */
        var destinationCidrBlock: String?
        /**
         * The destination port range.
         */
        var destinationPortRange: TrafficMirrorPortRangeRequest?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The protocol, for example UDP, to assign to the Traffic Mirror rule.
         * For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers on the  Internet Assigned Numbers Authority (IANA) website.
         */
        var protocol: Int?
        /**
         * The action to take on the filtered traffic.
         */
        var ruleAction: TrafficMirrorRuleAction?
        /**
         * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
         * direction. The rules are processed in ascending order by rule number.
         */
        var ruleNumber: Int?
        /**
         * The source CIDR block to assign to the Traffic Mirror rule.
         */
        var sourceCidrBlock: String?
        /**
         * The source port range.
         */
        var sourcePortRange: TrafficMirrorPortRangeRequest?
        /**
         * The type of traffic.
         */
        var trafficDirection: TrafficDirection?
        /**
         * The ID of the filter that this rule is associated with.
         */
        var trafficMirrorFilterId: String?

        fun build(): CreateTrafficMirrorFilterRuleRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest] inside the given [block]
         */
        fun destinationPortRange(block: TrafficMirrorPortRangeRequest.DslBuilder.() -> kotlin.Unit) {
            this.destinationPortRange = TrafficMirrorPortRangeRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TrafficMirrorPortRangeRequest] inside the given [block]
         */
        fun sourcePortRange(block: TrafficMirrorPortRangeRequest.DslBuilder.() -> kotlin.Unit) {
            this.sourcePortRange = TrafficMirrorPortRangeRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var destinationCidrBlock: String? = null
        override var destinationPortRange: TrafficMirrorPortRangeRequest? = null
        override var dryRun: Boolean? = null
        override var protocol: Int? = null
        override var ruleAction: TrafficMirrorRuleAction? = null
        override var ruleNumber: Int? = null
        override var sourceCidrBlock: String? = null
        override var sourcePortRange: TrafficMirrorPortRangeRequest? = null
        override var trafficDirection: TrafficDirection? = null
        override var trafficMirrorFilterId: String? = null

        constructor(x: CreateTrafficMirrorFilterRuleRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.destinationCidrBlock = x.destinationCidrBlock
            this.destinationPortRange = x.destinationPortRange
            this.dryRun = x.dryRun
            this.protocol = x.protocol
            this.ruleAction = x.ruleAction
            this.ruleNumber = x.ruleNumber
            this.sourceCidrBlock = x.sourceCidrBlock
            this.sourcePortRange = x.sourcePortRange
            this.trafficDirection = x.trafficDirection
            this.trafficMirrorFilterId = x.trafficMirrorFilterId
        }

        override fun build(): CreateTrafficMirrorFilterRuleRequest = CreateTrafficMirrorFilterRuleRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder = apply { this.destinationCidrBlock = destinationCidrBlock }
        override fun destinationPortRange(destinationPortRange: TrafficMirrorPortRangeRequest): FluentBuilder = apply { this.destinationPortRange = destinationPortRange }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun protocol(protocol: Int): FluentBuilder = apply { this.protocol = protocol }
        override fun ruleAction(ruleAction: TrafficMirrorRuleAction): FluentBuilder = apply { this.ruleAction = ruleAction }
        override fun ruleNumber(ruleNumber: Int): FluentBuilder = apply { this.ruleNumber = ruleNumber }
        override fun sourceCidrBlock(sourceCidrBlock: String): FluentBuilder = apply { this.sourceCidrBlock = sourceCidrBlock }
        override fun sourcePortRange(sourcePortRange: TrafficMirrorPortRangeRequest): FluentBuilder = apply { this.sourcePortRange = sourcePortRange }
        override fun trafficDirection(trafficDirection: TrafficDirection): FluentBuilder = apply { this.trafficDirection = trafficDirection }
        override fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder = apply { this.trafficMirrorFilterId = trafficMirrorFilterId }
    }
}
