// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateTrafficMirrorSessionRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The description of the Traffic Mirror session.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the source network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do
     * not specify this parameter when you want to mirror the entire packet. To mirror a subset of
     * the packet, set this to the length (in bytes) that you want to mirror. For example, if you
     * set this value to 100, then the first 100 bytes that meet the filter criteria are copied to
     * the target.
     * If you do not want to mirror the entire packet, use the PacketLength parameter to specify the number of bytes in each packet to mirror.
     */
    val packetLength: Int? = builder.packetLength
    /**
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     * Valid values are 1-32766.
     */
    val sessionNumber: Int? = builder.sessionNumber
    /**
     * The tags to assign to a Traffic Mirror session.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The ID of the Traffic Mirror filter.
     */
    val trafficMirrorFilterId: String? = builder.trafficMirrorFilterId
    /**
     * The ID of the Traffic Mirror target.
     */
    val trafficMirrorTargetId: String? = builder.trafficMirrorTargetId
    /**
     * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN
     * protocol, see <a href="https://tools.ietf.org/html/rfc7348">RFC 7348. If you do
     * not specify a VirtualNetworkId, an account-wide unique id is chosen at
     * random.
     */
    val virtualNetworkId: Int? = builder.virtualNetworkId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateTrafficMirrorSessionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrafficMirrorSessionRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("packetLength=$packetLength,")
        append("sessionNumber=$sessionNumber,")
        append("tagSpecifications=$tagSpecifications,")
        append("trafficMirrorFilterId=$trafficMirrorFilterId,")
        append("trafficMirrorTargetId=$trafficMirrorTargetId,")
        append("virtualNetworkId=$virtualNetworkId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (packetLength ?: 0)
        result = 31 * result + (sessionNumber ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorFilterId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorTargetId?.hashCode() ?: 0)
        result = 31 * result + (virtualNetworkId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateTrafficMirrorSessionRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (packetLength != other.packetLength) return false
        if (sessionNumber != other.sessionNumber) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (trafficMirrorFilterId != other.trafficMirrorFilterId) return false
        if (trafficMirrorTargetId != other.trafficMirrorTargetId) return false
        if (virtualNetworkId != other.virtualNetworkId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateTrafficMirrorSessionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateTrafficMirrorSessionRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The description of the Traffic Mirror session.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the source network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do
         * not specify this parameter when you want to mirror the entire packet. To mirror a subset of
         * the packet, set this to the length (in bytes) that you want to mirror. For example, if you
         * set this value to 100, then the first 100 bytes that meet the filter criteria are copied to
         * the target.
         * If you do not want to mirror the entire packet, use the PacketLength parameter to specify the number of bytes in each packet to mirror.
         */
        fun packetLength(packetLength: Int): FluentBuilder
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         * Valid values are 1-32766.
         */
        fun sessionNumber(sessionNumber: Int): FluentBuilder
        /**
         * The tags to assign to a Traffic Mirror session.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The ID of the Traffic Mirror filter.
         */
        fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder
        /**
         * The ID of the Traffic Mirror target.
         */
        fun trafficMirrorTargetId(trafficMirrorTargetId: String): FluentBuilder
        /**
         * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN
         * protocol, see <a href="https://tools.ietf.org/html/rfc7348">RFC 7348. If you do
         * not specify a VirtualNetworkId, an account-wide unique id is chosen at
         * random.
         */
        fun virtualNetworkId(virtualNetworkId: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        var clientToken: String?
        /**
         * The description of the Traffic Mirror session.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the source network interface.
         */
        var networkInterfaceId: String?
        /**
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do
         * not specify this parameter when you want to mirror the entire packet. To mirror a subset of
         * the packet, set this to the length (in bytes) that you want to mirror. For example, if you
         * set this value to 100, then the first 100 bytes that meet the filter criteria are copied to
         * the target.
         * If you do not want to mirror the entire packet, use the PacketLength parameter to specify the number of bytes in each packet to mirror.
         */
        var packetLength: Int?
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         * Valid values are 1-32766.
         */
        var sessionNumber: Int?
        /**
         * The tags to assign to a Traffic Mirror session.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The ID of the Traffic Mirror filter.
         */
        var trafficMirrorFilterId: String?
        /**
         * The ID of the Traffic Mirror target.
         */
        var trafficMirrorTargetId: String?
        /**
         * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN
         * protocol, see <a href="https://tools.ietf.org/html/rfc7348">RFC 7348. If you do
         * not specify a VirtualNetworkId, an account-wide unique id is chosen at
         * random.
         */
        var virtualNetworkId: Int?

        fun build(): CreateTrafficMirrorSessionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var networkInterfaceId: String? = null
        override var packetLength: Int? = null
        override var sessionNumber: Int? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var trafficMirrorFilterId: String? = null
        override var trafficMirrorTargetId: String? = null
        override var virtualNetworkId: Int? = null

        constructor(x: CreateTrafficMirrorSessionRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.dryRun = x.dryRun
            this.networkInterfaceId = x.networkInterfaceId
            this.packetLength = x.packetLength
            this.sessionNumber = x.sessionNumber
            this.tagSpecifications = x.tagSpecifications
            this.trafficMirrorFilterId = x.trafficMirrorFilterId
            this.trafficMirrorTargetId = x.trafficMirrorTargetId
            this.virtualNetworkId = x.virtualNetworkId
        }

        override fun build(): CreateTrafficMirrorSessionRequest = CreateTrafficMirrorSessionRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun packetLength(packetLength: Int): FluentBuilder = apply { this.packetLength = packetLength }
        override fun sessionNumber(sessionNumber: Int): FluentBuilder = apply { this.sessionNumber = sessionNumber }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun trafficMirrorFilterId(trafficMirrorFilterId: String): FluentBuilder = apply { this.trafficMirrorFilterId = trafficMirrorFilterId }
        override fun trafficMirrorTargetId(trafficMirrorTargetId: String): FluentBuilder = apply { this.trafficMirrorTargetId = trafficMirrorTargetId }
        override fun virtualNetworkId(virtualNetworkId: Int): FluentBuilder = apply { this.virtualNetworkId = virtualNetworkId }
    }
}
