// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateTransitGatewayConnectPeerRequest private constructor(builder: BuilderImpl) {
    /**
     * The BGP options for the Connect peer.
     */
    val bgpOptions: TransitGatewayConnectRequestBgpOptions? = builder.bgpOptions
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The range of inside IP addresses that are used for BGP peering. You must specify a
     * size /29 IPv4 CIDR block from the 169.254.0.0/16 range. The first address
     * from the range must be configured on the appliance as the BGP IP address. You can also
     * optionally specify a size /125 IPv6 CIDR block from the fd00::/8
     * range.
     */
    val insideCidrBlocks: List<String>? = builder.insideCidrBlocks
    /**
     * The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
     */
    val peerAddress: String? = builder.peerAddress
    /**
     * The tags to apply to the Connect peer.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be
     * specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns
     * the first available IP address from the transit gateway CIDR block.
     */
    val transitGatewayAddress: String? = builder.transitGatewayAddress
    /**
     * The ID of the Connect attachment.
     */
    val transitGatewayAttachmentId: String? = builder.transitGatewayAttachmentId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateTransitGatewayConnectPeerRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTransitGatewayConnectPeerRequest(")
        append("bgpOptions=$bgpOptions,")
        append("dryRun=$dryRun,")
        append("insideCidrBlocks=$insideCidrBlocks,")
        append("peerAddress=$peerAddress,")
        append("tagSpecifications=$tagSpecifications,")
        append("transitGatewayAddress=$transitGatewayAddress,")
        append("transitGatewayAttachmentId=$transitGatewayAttachmentId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bgpOptions?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (insideCidrBlocks?.hashCode() ?: 0)
        result = 31 * result + (peerAddress?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAddress?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAttachmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateTransitGatewayConnectPeerRequest

        if (bgpOptions != other.bgpOptions) return false
        if (dryRun != other.dryRun) return false
        if (insideCidrBlocks != other.insideCidrBlocks) return false
        if (peerAddress != other.peerAddress) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (transitGatewayAddress != other.transitGatewayAddress) return false
        if (transitGatewayAttachmentId != other.transitGatewayAttachmentId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateTransitGatewayConnectPeerRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateTransitGatewayConnectPeerRequest
        /**
         * The BGP options for the Connect peer.
         */
        fun bgpOptions(bgpOptions: TransitGatewayConnectRequestBgpOptions): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The range of inside IP addresses that are used for BGP peering. You must specify a
         * size /29 IPv4 CIDR block from the 169.254.0.0/16 range. The first address
         * from the range must be configured on the appliance as the BGP IP address. You can also
         * optionally specify a size /125 IPv6 CIDR block from the fd00::/8
         * range.
         */
        fun insideCidrBlocks(insideCidrBlocks: List<String>): FluentBuilder
        /**
         * The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
         */
        fun peerAddress(peerAddress: String): FluentBuilder
        /**
         * The tags to apply to the Connect peer.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be
         * specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns
         * the first available IP address from the transit gateway CIDR block.
         */
        fun transitGatewayAddress(transitGatewayAddress: String): FluentBuilder
        /**
         * The ID of the Connect attachment.
         */
        fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The BGP options for the Connect peer.
         */
        var bgpOptions: TransitGatewayConnectRequestBgpOptions?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The range of inside IP addresses that are used for BGP peering. You must specify a
         * size /29 IPv4 CIDR block from the 169.254.0.0/16 range. The first address
         * from the range must be configured on the appliance as the BGP IP address. You can also
         * optionally specify a size /125 IPv6 CIDR block from the fd00::/8
         * range.
         */
        var insideCidrBlocks: List<String>?
        /**
         * The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
         */
        var peerAddress: String?
        /**
         * The tags to apply to the Connect peer.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be
         * specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns
         * the first available IP address from the transit gateway CIDR block.
         */
        var transitGatewayAddress: String?
        /**
         * The ID of the Connect attachment.
         */
        var transitGatewayAttachmentId: String?

        fun build(): CreateTransitGatewayConnectPeerRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TransitGatewayConnectRequestBgpOptions] inside the given [block]
         */
        fun bgpOptions(block: TransitGatewayConnectRequestBgpOptions.DslBuilder.() -> kotlin.Unit) {
            this.bgpOptions = TransitGatewayConnectRequestBgpOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bgpOptions: TransitGatewayConnectRequestBgpOptions? = null
        override var dryRun: Boolean? = null
        override var insideCidrBlocks: List<String>? = null
        override var peerAddress: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var transitGatewayAddress: String? = null
        override var transitGatewayAttachmentId: String? = null

        constructor(x: CreateTransitGatewayConnectPeerRequest) : this() {
            this.bgpOptions = x.bgpOptions
            this.dryRun = x.dryRun
            this.insideCidrBlocks = x.insideCidrBlocks
            this.peerAddress = x.peerAddress
            this.tagSpecifications = x.tagSpecifications
            this.transitGatewayAddress = x.transitGatewayAddress
            this.transitGatewayAttachmentId = x.transitGatewayAttachmentId
        }

        override fun build(): CreateTransitGatewayConnectPeerRequest = CreateTransitGatewayConnectPeerRequest(this)
        override fun bgpOptions(bgpOptions: TransitGatewayConnectRequestBgpOptions): FluentBuilder = apply { this.bgpOptions = bgpOptions }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun insideCidrBlocks(insideCidrBlocks: List<String>): FluentBuilder = apply { this.insideCidrBlocks = insideCidrBlocks }
        override fun peerAddress(peerAddress: String): FluentBuilder = apply { this.peerAddress = peerAddress }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun transitGatewayAddress(transitGatewayAddress: String): FluentBuilder = apply { this.transitGatewayAddress = transitGatewayAddress }
        override fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder = apply { this.transitGatewayAttachmentId = transitGatewayAttachmentId }
    }
}
