// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CreateVpcEndpoint.
 */
class CreateVpcEndpointRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     * idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the
     * service. The policy must be in valid JSON format. If this parameter is not specified, we
     * attach a default policy that allows full access to the service.
     */
    val policyDocument: String? = builder.policyDocument
    /**
     * (Interface endpoint) Indicates whether to associate a private hosted zone with the
     * specified VPC. The private hosted zone contains a record set for the default public DNS
     * name for the service for the Region (for example,
     * kinesis.us-east-1.amazonaws.com), which resolves to the private IP
     * addresses of the endpoint network interfaces in the VPC. This enables you to make
     * requests to the default public DNS name for the service instead of the public DNS names
     * that are automatically generated by the VPC endpoint service.
     * To use a private hosted zone, you must set the following VPC attributes to
     * true: enableDnsHostnames and
     * enableDnsSupport. Use ModifyVpcAttribute to set the VPC
     * attributes.
     * Default: true
     */
    val privateDnsEnabled: Boolean? = builder.privateDnsEnabled
    /**
     * (Gateway endpoint) One or more route table IDs.
     */
    val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * (Interface endpoint) The ID of one or more security groups to associate with the
     * endpoint network interface.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The service name. To get a list of available services, use the DescribeVpcEndpointServices request, or get the name from the service
     * provider.
     */
    val serviceName: String? = builder.serviceName
    /**
     * (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint
     * network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags to associate with the endpoint.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The type of endpoint.
     * Default: Gateway
     */
    val vpcEndpointType: VpcEndpointType? = builder.vpcEndpointType
    /**
     * The ID of the VPC in which the endpoint will be used.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateVpcEndpointRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcEndpointRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("policyDocument=$policyDocument,")
        append("privateDnsEnabled=$privateDnsEnabled,")
        append("routeTableIds=$routeTableIds,")
        append("securityGroupIds=$securityGroupIds,")
        append("serviceName=$serviceName,")
        append("subnetIds=$subnetIds,")
        append("tagSpecifications=$tagSpecifications,")
        append("vpcEndpointType=$vpcEndpointType,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (privateDnsEnabled?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateVpcEndpointRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (policyDocument != other.policyDocument) return false
        if (privateDnsEnabled != other.privateDnsEnabled) return false
        if (routeTableIds != other.routeTableIds) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serviceName != other.serviceName) return false
        if (subnetIds != other.subnetIds) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (vpcEndpointType != other.vpcEndpointType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateVpcEndpointRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateVpcEndpointRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the
         * service. The policy must be in valid JSON format. If this parameter is not specified, we
         * attach a default policy that allows full access to the service.
         */
        fun policyDocument(policyDocument: String): FluentBuilder
        /**
         * (Interface endpoint) Indicates whether to associate a private hosted zone with the
         * specified VPC. The private hosted zone contains a record set for the default public DNS
         * name for the service for the Region (for example,
         * kinesis.us-east-1.amazonaws.com), which resolves to the private IP
         * addresses of the endpoint network interfaces in the VPC. This enables you to make
         * requests to the default public DNS name for the service instead of the public DNS names
         * that are automatically generated by the VPC endpoint service.
         * To use a private hosted zone, you must set the following VPC attributes to
         * true: enableDnsHostnames and
         * enableDnsSupport. Use ModifyVpcAttribute to set the VPC
         * attributes.
         * Default: true
         */
        fun privateDnsEnabled(privateDnsEnabled: Boolean): FluentBuilder
        /**
         * (Gateway endpoint) One or more route table IDs.
         */
        fun routeTableIds(routeTableIds: List<String>): FluentBuilder
        /**
         * (Interface endpoint) The ID of one or more security groups to associate with the
         * endpoint network interface.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * The service name. To get a list of available services, use the DescribeVpcEndpointServices request, or get the name from the service
         * provider.
         */
        fun serviceName(serviceName: String): FluentBuilder
        /**
         * (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint
         * network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.
         */
        fun subnetIds(subnetIds: List<String>): FluentBuilder
        /**
         * The tags to associate with the endpoint.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The type of endpoint.
         * Default: Gateway
         */
        fun vpcEndpointType(vpcEndpointType: VpcEndpointType): FluentBuilder
        /**
         * The ID of the VPC in which the endpoint will be used.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the
         * service. The policy must be in valid JSON format. If this parameter is not specified, we
         * attach a default policy that allows full access to the service.
         */
        var policyDocument: String?
        /**
         * (Interface endpoint) Indicates whether to associate a private hosted zone with the
         * specified VPC. The private hosted zone contains a record set for the default public DNS
         * name for the service for the Region (for example,
         * kinesis.us-east-1.amazonaws.com), which resolves to the private IP
         * addresses of the endpoint network interfaces in the VPC. This enables you to make
         * requests to the default public DNS name for the service instead of the public DNS names
         * that are automatically generated by the VPC endpoint service.
         * To use a private hosted zone, you must set the following VPC attributes to
         * true: enableDnsHostnames and
         * enableDnsSupport. Use ModifyVpcAttribute to set the VPC
         * attributes.
         * Default: true
         */
        var privateDnsEnabled: Boolean?
        /**
         * (Gateway endpoint) One or more route table IDs.
         */
        var routeTableIds: List<String>?
        /**
         * (Interface endpoint) The ID of one or more security groups to associate with the
         * endpoint network interface.
         */
        var securityGroupIds: List<String>?
        /**
         * The service name. To get a list of available services, use the DescribeVpcEndpointServices request, or get the name from the service
         * provider.
         */
        var serviceName: String?
        /**
         * (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint
         * network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.
         */
        var subnetIds: List<String>?
        /**
         * The tags to associate with the endpoint.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The type of endpoint.
         * Default: Gateway
         */
        var vpcEndpointType: VpcEndpointType?
        /**
         * The ID of the VPC in which the endpoint will be used.
         */
        var vpcId: String?

        fun build(): CreateVpcEndpointRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var policyDocument: String? = null
        override var privateDnsEnabled: Boolean? = null
        override var routeTableIds: List<String>? = null
        override var securityGroupIds: List<String>? = null
        override var serviceName: String? = null
        override var subnetIds: List<String>? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var vpcEndpointType: VpcEndpointType? = null
        override var vpcId: String? = null

        constructor(x: CreateVpcEndpointRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.policyDocument = x.policyDocument
            this.privateDnsEnabled = x.privateDnsEnabled
            this.routeTableIds = x.routeTableIds
            this.securityGroupIds = x.securityGroupIds
            this.serviceName = x.serviceName
            this.subnetIds = x.subnetIds
            this.tagSpecifications = x.tagSpecifications
            this.vpcEndpointType = x.vpcEndpointType
            this.vpcId = x.vpcId
        }

        override fun build(): CreateVpcEndpointRequest = CreateVpcEndpointRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun policyDocument(policyDocument: String): FluentBuilder = apply { this.policyDocument = policyDocument }
        override fun privateDnsEnabled(privateDnsEnabled: Boolean): FluentBuilder = apply { this.privateDnsEnabled = privateDnsEnabled }
        override fun routeTableIds(routeTableIds: List<String>): FluentBuilder = apply { this.routeTableIds = routeTableIds }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun serviceName(serviceName: String): FluentBuilder = apply { this.serviceName = serviceName }
        override fun subnetIds(subnetIds: List<String>): FluentBuilder = apply { this.subnetIds = subnetIds }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun vpcEndpointType(vpcEndpointType: VpcEndpointType): FluentBuilder = apply { this.vpcEndpointType = vpcEndpointType }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
