// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateVpcEndpointServiceConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether requests from service consumers to create an endpoint to your service must
     * be accepted. To accept a request, use AcceptVpcEndpointConnections.
     */
    val acceptanceRequired: Boolean? = builder.acceptanceRequired
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
     * idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
     */
    val gatewayLoadBalancerArns: List<String>? = builder.gatewayLoadBalancerArns
    /**
     * The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your
     * service.
     */
    val networkLoadBalancerArns: List<String>? = builder.networkLoadBalancerArns
    /**
     * (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * The tags to associate with the service.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateVpcEndpointServiceConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcEndpointServiceConfigurationRequest(")
        append("acceptanceRequired=$acceptanceRequired,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("gatewayLoadBalancerArns=$gatewayLoadBalancerArns,")
        append("networkLoadBalancerArns=$networkLoadBalancerArns,")
        append("privateDnsName=$privateDnsName,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceRequired?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (gatewayLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (networkLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateVpcEndpointServiceConfigurationRequest

        if (acceptanceRequired != other.acceptanceRequired) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (gatewayLoadBalancerArns != other.gatewayLoadBalancerArns) return false
        if (networkLoadBalancerArns != other.networkLoadBalancerArns) return false
        if (privateDnsName != other.privateDnsName) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateVpcEndpointServiceConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateVpcEndpointServiceConfigurationRequest
        /**
         * Indicates whether requests from service consumers to create an endpoint to your service must
         * be accepted. To accept a request, use AcceptVpcEndpointConnections.
         */
        fun acceptanceRequired(acceptanceRequired: Boolean): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
         */
        fun gatewayLoadBalancerArns(gatewayLoadBalancerArns: List<String>): FluentBuilder
        /**
         * The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your
         * service.
         */
        fun networkLoadBalancerArns(networkLoadBalancerArns: List<String>): FluentBuilder
        /**
         * (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * The tags to associate with the service.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether requests from service consumers to create an endpoint to your service must
         * be accepted. To accept a request, use AcceptVpcEndpointConnections.
         */
        var acceptanceRequired: Boolean?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
         */
        var gatewayLoadBalancerArns: List<String>?
        /**
         * The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your
         * service.
         */
        var networkLoadBalancerArns: List<String>?
        /**
         * (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
         */
        var privateDnsName: String?
        /**
         * The tags to associate with the service.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateVpcEndpointServiceConfigurationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var acceptanceRequired: Boolean? = null
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var gatewayLoadBalancerArns: List<String>? = null
        override var networkLoadBalancerArns: List<String>? = null
        override var privateDnsName: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateVpcEndpointServiceConfigurationRequest) : this() {
            this.acceptanceRequired = x.acceptanceRequired
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.gatewayLoadBalancerArns = x.gatewayLoadBalancerArns
            this.networkLoadBalancerArns = x.networkLoadBalancerArns
            this.privateDnsName = x.privateDnsName
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateVpcEndpointServiceConfigurationRequest = CreateVpcEndpointServiceConfigurationRequest(this)
        override fun acceptanceRequired(acceptanceRequired: Boolean): FluentBuilder = apply { this.acceptanceRequired = acceptanceRequired }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun gatewayLoadBalancerArns(gatewayLoadBalancerArns: List<String>): FluentBuilder = apply { this.gatewayLoadBalancerArns = gatewayLoadBalancerArns }
        override fun networkLoadBalancerArns(networkLoadBalancerArns: List<String>): FluentBuilder = apply { this.networkLoadBalancerArns = networkLoadBalancerArns }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
