// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a customer gateway.
 */
class CustomerGateway private constructor(builder: BuilderImpl) {
    /**
     * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
     * (ASN).
     */
    val bgpAsn: String? = builder.bgpAsn
    /**
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * The ID of the customer gateway.
     */
    val customerGatewayId: String? = builder.customerGatewayId
    /**
     * The name of customer gateway device.
     */
    val deviceName: String? = builder.deviceName
    /**
     * The Internet-routable IP address of the customer gateway's outside interface.
     */
    val ipAddress: String? = builder.ipAddress
    /**
     * The current state of the customer gateway (pending | available | deleting |
     * deleted).
     */
    val state: String? = builder.state
    /**
     * Any tags assigned to the customer gateway.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of VPN connection the customer gateway supports
     * (ipsec.1).
     */
    val type: String? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomerGateway = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomerGateway(")
        append("bgpAsn=$bgpAsn,")
        append("certificateArn=$certificateArn,")
        append("customerGatewayId=$customerGatewayId,")
        append("deviceName=$deviceName,")
        append("ipAddress=$ipAddress,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bgpAsn?.hashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (customerGatewayId?.hashCode() ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomerGateway

        if (bgpAsn != other.bgpAsn) return false
        if (certificateArn != other.certificateArn) return false
        if (customerGatewayId != other.customerGatewayId) return false
        if (deviceName != other.deviceName) return false
        if (ipAddress != other.ipAddress) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomerGateway = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomerGateway
        /**
         * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
         * (ASN).
         */
        fun bgpAsn(bgpAsn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the customer gateway certificate.
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * The ID of the customer gateway.
         */
        fun customerGatewayId(customerGatewayId: String): FluentBuilder
        /**
         * The name of customer gateway device.
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * The Internet-routable IP address of the customer gateway's outside interface.
         */
        fun ipAddress(ipAddress: String): FluentBuilder
        /**
         * The current state of the customer gateway (pending | available | deleting |
         * deleted).
         */
        fun state(state: String): FluentBuilder
        /**
         * Any tags assigned to the customer gateway.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The type of VPN connection the customer gateway supports
         * (ipsec.1).
         */
        fun type(type: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
         * (ASN).
         */
        var bgpAsn: String?
        /**
         * The Amazon Resource Name (ARN) for the customer gateway certificate.
         */
        var certificateArn: String?
        /**
         * The ID of the customer gateway.
         */
        var customerGatewayId: String?
        /**
         * The name of customer gateway device.
         */
        var deviceName: String?
        /**
         * The Internet-routable IP address of the customer gateway's outside interface.
         */
        var ipAddress: String?
        /**
         * The current state of the customer gateway (pending | available | deleting |
         * deleted).
         */
        var state: String?
        /**
         * Any tags assigned to the customer gateway.
         */
        var tags: List<Tag>?
        /**
         * The type of VPN connection the customer gateway supports
         * (ipsec.1).
         */
        var type: String?

        fun build(): CustomerGateway
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bgpAsn: String? = null
        override var certificateArn: String? = null
        override var customerGatewayId: String? = null
        override var deviceName: String? = null
        override var ipAddress: String? = null
        override var state: String? = null
        override var tags: List<Tag>? = null
        override var type: String? = null

        constructor(x: CustomerGateway) : this() {
            this.bgpAsn = x.bgpAsn
            this.certificateArn = x.certificateArn
            this.customerGatewayId = x.customerGatewayId
            this.deviceName = x.deviceName
            this.ipAddress = x.ipAddress
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
        }

        override fun build(): CustomerGateway = CustomerGateway(this)
        override fun bgpAsn(bgpAsn: String): FluentBuilder = apply { this.bgpAsn = bgpAsn }
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun customerGatewayId(customerGatewayId: String): FluentBuilder = apply { this.customerGatewayId = customerGatewayId }
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun ipAddress(ipAddress: String): FluentBuilder = apply { this.ipAddress = ipAddress }
        override fun state(state: String): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
    }
}
