// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DeleteClientVpnRouteRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the Client VPN endpoint from which the route is to be deleted.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * The IPv4 address range, in CIDR notation, of the route to be deleted.
     */
    val destinationCidrBlock: String? = builder.destinationCidrBlock
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the target subnet used by the route.
     */
    val targetVpcSubnetId: String? = builder.targetVpcSubnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteClientVpnRouteRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteClientVpnRouteRequest(")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("dryRun=$dryRun,")
        append("targetVpcSubnetId=$targetVpcSubnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientVpnEndpointId?.hashCode() ?: 0
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (targetVpcSubnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteClientVpnRouteRequest

        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (dryRun != other.dryRun) return false
        if (targetVpcSubnetId != other.targetVpcSubnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteClientVpnRouteRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteClientVpnRouteRequest
        /**
         * The ID of the Client VPN endpoint from which the route is to be deleted.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * The IPv4 address range, in CIDR notation, of the route to be deleted.
         */
        fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the target subnet used by the route.
         */
        fun targetVpcSubnetId(targetVpcSubnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the Client VPN endpoint from which the route is to be deleted.
         */
        var clientVpnEndpointId: String?
        /**
         * The IPv4 address range, in CIDR notation, of the route to be deleted.
         */
        var destinationCidrBlock: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the target subnet used by the route.
         */
        var targetVpcSubnetId: String?

        fun build(): DeleteClientVpnRouteRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientVpnEndpointId: String? = null
        override var destinationCidrBlock: String? = null
        override var dryRun: Boolean? = null
        override var targetVpcSubnetId: String? = null

        constructor(x: DeleteClientVpnRouteRequest) : this() {
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.destinationCidrBlock = x.destinationCidrBlock
            this.dryRun = x.dryRun
            this.targetVpcSubnetId = x.targetVpcSubnetId
        }

        override fun build(): DeleteClientVpnRouteRequest = DeleteClientVpnRouteRequest(this)
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder = apply { this.destinationCidrBlock = destinationCidrBlock }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun targetVpcSubnetId(targetVpcSubnetId: String): FluentBuilder = apply { this.targetVpcSubnetId = targetVpcSubnetId }
    }
}
