// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DeleteTagsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The IDs of the resources, separated by spaces.
     * Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.
     */
    val resources: List<String>? = builder.resources
    /**
     * The tags to delete. Specify a tag key and an optional tag value to delete
     * specific tags. If you specify a tag key without a tag value, we delete any tag with this
     * key regardless of its value. If you specify a tag key with an empty string as the tag
     * value, we delete the tag only if its value is an empty string.
     * If you omit this parameter, we delete all user-defined tags for the specified
     * resources. We do not delete Amazon Web Services-generated tags (tags that have the aws:
     * prefix).
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteTagsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteTagsRequest(")
        append("dryRun=$dryRun,")
        append("resources=$resources,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteTagsRequest

        if (dryRun != other.dryRun) return false
        if (resources != other.resources) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteTagsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteTagsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The IDs of the resources, separated by spaces.
         * Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.
         */
        fun resources(resources: List<String>): FluentBuilder
        /**
         * The tags to delete. Specify a tag key and an optional tag value to delete
         * specific tags. If you specify a tag key without a tag value, we delete any tag with this
         * key regardless of its value. If you specify a tag key with an empty string as the tag
         * value, we delete the tag only if its value is an empty string.
         * If you omit this parameter, we delete all user-defined tags for the specified
         * resources. We do not delete Amazon Web Services-generated tags (tags that have the aws:
         * prefix).
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The IDs of the resources, separated by spaces.
         * Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.
         */
        var resources: List<String>?
        /**
         * The tags to delete. Specify a tag key and an optional tag value to delete
         * specific tags. If you specify a tag key without a tag value, we delete any tag with this
         * key regardless of its value. If you specify a tag key with an empty string as the tag
         * value, we delete the tag only if its value is an empty string.
         * If you omit this parameter, we delete all user-defined tags for the specified
         * resources. We do not delete Amazon Web Services-generated tags (tags that have the aws:
         * prefix).
         */
        var tags: List<Tag>?

        fun build(): DeleteTagsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var resources: List<String>? = null
        override var tags: List<Tag>? = null

        constructor(x: DeleteTagsRequest) : this() {
            this.dryRun = x.dryRun
            this.resources = x.resources
            this.tags = x.tags
        }

        override fun build(): DeleteTagsRequest = DeleteTagsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun resources(resources: List<String>): FluentBuilder = apply { this.resources = resources }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
