// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeAddressesRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;EC2-VPC&#93; Information about the allocation IDs.
     */
    val allocationIds: List<String>? = builder.allocationIds
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters. Filter names and values are case-sensitive.
     * allocation-id - &#91;EC2-VPC&#93; The allocation ID for the address.
     * association-id - &#91;EC2-VPC&#93; The association ID for the address.
     * domain - Indicates whether the address is for use in EC2-Classic (standard)
     * or in a VPC (vpc).
     * instance-id - The ID of the instance the address is associated with, if any.
     * network-border-group -  A unique set of Availability Zones, Local Zones,
     * or Wavelength Zones from where Amazon Web Services advertises IP addresses.
     * network-interface-id - &#91;EC2-VPC&#93; The ID of the network interface that the address is associated with, if any.
     * network-interface-owner-id - The Amazon Web Services account ID of the owner.
     * private-ip-address - &#91;EC2-VPC&#93; The private IP address associated with the Elastic IP address.
     * public-ip - The Elastic IP address, or the carrier IP address.
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * One or more Elastic IP addresses.
     * Default: Describes all your Elastic IP addresses.
     */
    val publicIps: List<String>? = builder.publicIps

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeAddressesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAddressesRequest(")
        append("allocationIds=$allocationIds,")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("publicIps=$publicIps)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationIds?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (publicIps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeAddressesRequest

        if (allocationIds != other.allocationIds) return false
        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (publicIps != other.publicIps) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeAddressesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeAddressesRequest
        /**
         * &#91;EC2-VPC&#93; Information about the allocation IDs.
         */
        fun allocationIds(allocationIds: List<String>): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters. Filter names and values are case-sensitive.
         * allocation-id - &#91;EC2-VPC&#93; The allocation ID for the address.
         * association-id - &#91;EC2-VPC&#93; The association ID for the address.
         * domain - Indicates whether the address is for use in EC2-Classic (standard)
         * or in a VPC (vpc).
         * instance-id - The ID of the instance the address is associated with, if any.
         * network-border-group -  A unique set of Availability Zones, Local Zones,
         * or Wavelength Zones from where Amazon Web Services advertises IP addresses.
         * network-interface-id - &#91;EC2-VPC&#93; The ID of the network interface that the address is associated with, if any.
         * network-interface-owner-id - The Amazon Web Services account ID of the owner.
         * private-ip-address - &#91;EC2-VPC&#93; The private IP address associated with the Elastic IP address.
         * public-ip - The Elastic IP address, or the carrier IP address.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * One or more Elastic IP addresses.
         * Default: Describes all your Elastic IP addresses.
         */
        fun publicIps(publicIps: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;EC2-VPC&#93; Information about the allocation IDs.
         */
        var allocationIds: List<String>?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters. Filter names and values are case-sensitive.
         * allocation-id - &#91;EC2-VPC&#93; The allocation ID for the address.
         * association-id - &#91;EC2-VPC&#93; The association ID for the address.
         * domain - Indicates whether the address is for use in EC2-Classic (standard)
         * or in a VPC (vpc).
         * instance-id - The ID of the instance the address is associated with, if any.
         * network-border-group -  A unique set of Availability Zones, Local Zones,
         * or Wavelength Zones from where Amazon Web Services advertises IP addresses.
         * network-interface-id - &#91;EC2-VPC&#93; The ID of the network interface that the address is associated with, if any.
         * network-interface-owner-id - The Amazon Web Services account ID of the owner.
         * private-ip-address - &#91;EC2-VPC&#93; The private IP address associated with the Elastic IP address.
         * public-ip - The Elastic IP address, or the carrier IP address.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        var filters: List<Filter>?
        /**
         * One or more Elastic IP addresses.
         * Default: Describes all your Elastic IP addresses.
         */
        var publicIps: List<String>?

        fun build(): DescribeAddressesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationIds: List<String>? = null
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var publicIps: List<String>? = null

        constructor(x: DescribeAddressesRequest) : this() {
            this.allocationIds = x.allocationIds
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.publicIps = x.publicIps
        }

        override fun build(): DescribeAddressesRequest = DescribeAddressesRequest(this)
        override fun allocationIds(allocationIds: List<String>): FluentBuilder = apply { this.allocationIds = allocationIds }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun publicIps(publicIps: List<String>): FluentBuilder = apply { this.publicIps = publicIps }
    }
}
