// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeCapacityReservationsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationIds: List<String>? = builder.capacityReservationIds
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * instance-type - The type of instance for which the Capacity Reservation reserves capacity.
     * owner-id - The ID of the Amazon Web Services account that owns the Capacity Reservation.
     * availability-zone-id - The Availability Zone ID of the Capacity Reservation.
     * instance-platform - The type of operating system for which the Capacity Reservation reserves capacity.
     * availability-zone - The Availability Zone ID of the Capacity Reservation.
     * tenancy - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
     * following tenancy settings:
     * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
     * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
     * outpost-arn - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
     * state - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * active- The Capacity Reservation is active and the capacity is available for your use.
     * expired - The Capacity Reservation expired automatically at the date and time specified in your request.
     * The reserved capacity is no longer available for your use.
     * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
     * pending - The Capacity Reservation request was successful but the capacity provisioning is still pending.
     * failed - The Capacity Reservation request has failed. A request might fail due to invalid request parameters,
     * capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     * start-date - The date and time at which the Capacity Reservation was started.
     * end-date - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is
     * released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.
     * end-date-type - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
     * unlimited - The Capacity Reservation remains active until you explicitly cancel it.
     * limited - The Capacity Reservation expires automatically at a specified date and time.
     * instance-match-criteria - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * open - The Capacity Reservation accepts all instances that have matching
     * attributes (instance type, platform, and Availability Zone). Instances
     * that have matching attributes launch into the Capacity Reservation
     * automatically without specifying any additional parameters.
     * targeted - The Capacity Reservation only accepts instances that have matching
     * attributes (instance type, platform, and Availability Zone), and
     * explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeCapacityReservationsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCapacityReservationsRequest(")
        append("capacityReservationIds=$capacityReservationIds,")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityReservationIds?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeCapacityReservationsRequest

        if (capacityReservationIds != other.capacityReservationIds) return false
        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeCapacityReservationsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeCapacityReservationsRequest
        /**
         * The ID of the Capacity Reservation.
         */
        fun capacityReservationIds(capacityReservationIds: List<String>): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * instance-type - The type of instance for which the Capacity Reservation reserves capacity.
         * owner-id - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * availability-zone-id - The Availability Zone ID of the Capacity Reservation.
         * instance-platform - The type of operating system for which the Capacity Reservation reserves capacity.
         * availability-zone - The Availability Zone ID of the Capacity Reservation.
         * tenancy - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         * following tenancy settings:
         * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         * outpost-arn - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
         * state - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * active- The Capacity Reservation is active and the capacity is available for your use.
         * expired - The Capacity Reservation expired automatically at the date and time specified in your request.
         * The reserved capacity is no longer available for your use.
         * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
         * pending - The Capacity Reservation request was successful but the capacity provisioning is still pending.
         * failed - The Capacity Reservation request has failed. A request might fail due to invalid request parameters,
         * capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
         * start-date - The date and time at which the Capacity Reservation was started.
         * end-date - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is
         * released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.
         * end-date-type - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it.
         * limited - The Capacity Reservation expires automatically at a specified date and time.
         * instance-match-criteria - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * open - The Capacity Reservation accepts all instances that have matching
         * attributes (instance type, platform, and Availability Zone). Instances
         * that have matching attributes launch into the Capacity Reservation
         * automatically without specifying any additional parameters.
         * targeted - The Capacity Reservation only accepts instances that have matching
         * attributes (instance type, platform, and Availability Zone), and
         * explicitly target the Capacity Reservation. This ensures that only
         * permitted instances can use the reserved capacity.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to use to retrieve the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationIds: List<String>?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * instance-type - The type of instance for which the Capacity Reservation reserves capacity.
         * owner-id - The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * availability-zone-id - The Availability Zone ID of the Capacity Reservation.
         * instance-platform - The type of operating system for which the Capacity Reservation reserves capacity.
         * availability-zone - The Availability Zone ID of the Capacity Reservation.
         * tenancy - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         * following tenancy settings:
         * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         * outpost-arn - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
         * state - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * active- The Capacity Reservation is active and the capacity is available for your use.
         * expired - The Capacity Reservation expired automatically at the date and time specified in your request.
         * The reserved capacity is no longer available for your use.
         * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
         * pending - The Capacity Reservation request was successful but the capacity provisioning is still pending.
         * failed - The Capacity Reservation request has failed. A request might fail due to invalid request parameters,
         * capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
         * start-date - The date and time at which the Capacity Reservation was started.
         * end-date - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is
         * released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.
         * end-date-type - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it.
         * limited - The Capacity Reservation expires automatically at a specified date and time.
         * instance-match-criteria - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * open - The Capacity Reservation accepts all instances that have matching
         * attributes (instance type, platform, and Availability Zone). Instances
         * that have matching attributes launch into the Capacity Reservation
         * automatically without specifying any additional parameters.
         * targeted - The Capacity Reservation only accepts instances that have matching
         * attributes (instance type, platform, and Availability Zone), and
         * explicitly target the Capacity Reservation. This ensures that only
         * permitted instances can use the reserved capacity.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
         */
        var maxResults: Int?
        /**
         * The token to use to retrieve the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeCapacityReservationsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capacityReservationIds: List<String>? = null
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeCapacityReservationsRequest) : this() {
            this.capacityReservationIds = x.capacityReservationIds
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeCapacityReservationsRequest = DescribeCapacityReservationsRequest(this)
        override fun capacityReservationIds(capacityReservationIds: List<String>): FluentBuilder = apply { this.capacityReservationIds = capacityReservationIds }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
