// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the instances that were launched by the fleet.
 */
class DescribeFleetsInstances private constructor(builder: BuilderImpl) {
    /**
     * The IDs of the instances.
     */
    val instanceIds: List<String>? = builder.instanceIds
    /**
     * The instance type.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The launch templates and overrides that were used for launching the instances. The
     * values that you specify in the Overrides replace the values in the launch template.
     */
    val launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse? = builder.launchTemplateAndOverrides
    /**
     * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     */
    val lifecycle: InstanceLifecycle? = builder.lifecycle
    /**
     * The value is Windows for Windows instances. Otherwise, the value is
     * blank.
     */
    val platform: PlatformValues? = builder.platform

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeFleetsInstances = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetsInstances(")
        append("instanceIds=$instanceIds,")
        append("instanceType=$instanceType,")
        append("launchTemplateAndOverrides=$launchTemplateAndOverrides,")
        append("lifecycle=$lifecycle,")
        append("platform=$platform)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceIds?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateAndOverrides?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeFleetsInstances

        if (instanceIds != other.instanceIds) return false
        if (instanceType != other.instanceType) return false
        if (launchTemplateAndOverrides != other.launchTemplateAndOverrides) return false
        if (lifecycle != other.lifecycle) return false
        if (platform != other.platform) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeFleetsInstances = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeFleetsInstances
        /**
         * The IDs of the instances.
         */
        fun instanceIds(instanceIds: List<String>): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The launch templates and overrides that were used for launching the instances. The
         * values that you specify in the Overrides replace the values in the launch template.
         */
        fun launchTemplateAndOverrides(launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse): FluentBuilder
        /**
         * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
         */
        fun lifecycle(lifecycle: InstanceLifecycle): FluentBuilder
        /**
         * The value is Windows for Windows instances. Otherwise, the value is
         * blank.
         */
        fun platform(platform: PlatformValues): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IDs of the instances.
         */
        var instanceIds: List<String>?
        /**
         * The instance type.
         */
        var instanceType: InstanceType?
        /**
         * The launch templates and overrides that were used for launching the instances. The
         * values that you specify in the Overrides replace the values in the launch template.
         */
        var launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse?
        /**
         * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
         */
        var lifecycle: InstanceLifecycle?
        /**
         * The value is Windows for Windows instances. Otherwise, the value is
         * blank.
         */
        var platform: PlatformValues?

        fun build(): DescribeFleetsInstances
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse] inside the given [block]
         */
        fun launchTemplateAndOverrides(block: LaunchTemplateAndOverridesResponse.DslBuilder.() -> kotlin.Unit) {
            this.launchTemplateAndOverrides = LaunchTemplateAndOverridesResponse.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var instanceIds: List<String>? = null
        override var instanceType: InstanceType? = null
        override var launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse? = null
        override var lifecycle: InstanceLifecycle? = null
        override var platform: PlatformValues? = null

        constructor(x: DescribeFleetsInstances) : this() {
            this.instanceIds = x.instanceIds
            this.instanceType = x.instanceType
            this.launchTemplateAndOverrides = x.launchTemplateAndOverrides
            this.lifecycle = x.lifecycle
            this.platform = x.platform
        }

        override fun build(): DescribeFleetsInstances = DescribeFleetsInstances(this)
        override fun instanceIds(instanceIds: List<String>): FluentBuilder = apply { this.instanceIds = instanceIds }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun launchTemplateAndOverrides(launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse): FluentBuilder = apply { this.launchTemplateAndOverrides = launchTemplateAndOverrides }
        override fun lifecycle(lifecycle: InstanceLifecycle): FluentBuilder = apply { this.lifecycle = lifecycle }
        override fun platform(platform: PlatformValues): FluentBuilder = apply { this.platform = platform }
    }
}
