// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeFleetsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The filters.
     * activity-status - The progress of the EC2 Fleet ( error |
     * pending-fulfillment | pending-termination |
     * fulfilled).
     * excess-capacity-termination-policy - Indicates whether to terminate
     * running instances if the target capacity is decreased below the current EC2 Fleet size
     * (true | false).
     * fleet-state - The state of the EC2 Fleet (submitted |
     * active | deleted | failed |
     * deleted-running | deleted-terminating |
     * modifying).
     * replace-unhealthy-instances - Indicates whether EC2 Fleet should replace
     * unhealthy instances (true | false).
     * type - The type of request (instant |
     * request | maintain).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The ID of the EC2 Fleets.
     */
    val fleetIds: List<String>? = builder.fleetIds
    /**
     * The maximum number of results to return in a single call. Specify a value between 1 and
     * 1000. The default value is 1000. To retrieve the remaining results, make another call with
     * the returned NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeFleetsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("fleetIds=$fleetIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (fleetIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeFleetsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (fleetIds != other.fleetIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeFleetsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeFleetsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The filters.
         * activity-status - The progress of the EC2 Fleet ( error |
         * pending-fulfillment | pending-termination |
         * fulfilled).
         * excess-capacity-termination-policy - Indicates whether to terminate
         * running instances if the target capacity is decreased below the current EC2 Fleet size
         * (true | false).
         * fleet-state - The state of the EC2 Fleet (submitted |
         * active | deleted | failed |
         * deleted-running | deleted-terminating |
         * modifying).
         * replace-unhealthy-instances - Indicates whether EC2 Fleet should replace
         * unhealthy instances (true | false).
         * type - The type of request (instant |
         * request | maintain).
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The ID of the EC2 Fleets.
         */
        fun fleetIds(fleetIds: List<String>): FluentBuilder
        /**
         * The maximum number of results to return in a single call. Specify a value between 1 and
         * 1000. The default value is 1000. To retrieve the remaining results, make another call with
         * the returned NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The filters.
         * activity-status - The progress of the EC2 Fleet ( error |
         * pending-fulfillment | pending-termination |
         * fulfilled).
         * excess-capacity-termination-policy - Indicates whether to terminate
         * running instances if the target capacity is decreased below the current EC2 Fleet size
         * (true | false).
         * fleet-state - The state of the EC2 Fleet (submitted |
         * active | deleted | failed |
         * deleted-running | deleted-terminating |
         * modifying).
         * replace-unhealthy-instances - Indicates whether EC2 Fleet should replace
         * unhealthy instances (true | false).
         * type - The type of request (instant |
         * request | maintain).
         */
        var filters: List<Filter>?
        /**
         * The ID of the EC2 Fleets.
         */
        var fleetIds: List<String>?
        /**
         * The maximum number of results to return in a single call. Specify a value between 1 and
         * 1000. The default value is 1000. To retrieve the remaining results, make another call with
         * the returned NextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?

        fun build(): DescribeFleetsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var fleetIds: List<String>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeFleetsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.fleetIds = x.fleetIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeFleetsRequest = DescribeFleetsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun fleetIds(fleetIds: List<String>): FluentBuilder = apply { this.fleetIds = fleetIds }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
