// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeFlowLogsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * deliver-log-status - The status of the logs delivery (SUCCESS |
     * FAILED).
     * log-destination-type - The type of destination to which the flow
     * log publishes data. Possible destination types include
     * cloud-watch-logs and s3.
     * flow-log-id - The ID of the flow log.
     * log-group-name - The name of the log group.
     * resource-id - The ID of the VPC, subnet, or network interface.
     * traffic-type - The type of traffic (ACCEPT |
     * REJECT | ALL).
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    val filter: List<Filter>? = builder.filter
    /**
     * One or more flow log IDs.
     * Constraint: Maximum of 1000 flow log IDs.
     */
    val flowLogIds: List<String>? = builder.flowLogIds
    /**
     * The maximum number of results to return with a single call.
     * To retrieve the remaining results, make another call with the returned nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeFlowLogsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFlowLogsRequest(")
        append("dryRun=$dryRun,")
        append("filter=$filter,")
        append("flowLogIds=$flowLogIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (flowLogIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeFlowLogsRequest

        if (dryRun != other.dryRun) return false
        if (filter != other.filter) return false
        if (flowLogIds != other.flowLogIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeFlowLogsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeFlowLogsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * deliver-log-status - The status of the logs delivery (SUCCESS |
         * FAILED).
         * log-destination-type - The type of destination to which the flow
         * log publishes data. Possible destination types include
         * cloud-watch-logs and s3.
         * flow-log-id - The ID of the flow log.
         * log-group-name - The name of the log group.
         * resource-id - The ID of the VPC, subnet, or network interface.
         * traffic-type - The type of traffic (ACCEPT |
         * REJECT | ALL).
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        fun filter(filter: List<Filter>): FluentBuilder
        /**
         * One or more flow log IDs.
         * Constraint: Maximum of 1000 flow log IDs.
         */
        fun flowLogIds(flowLogIds: List<String>): FluentBuilder
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * deliver-log-status - The status of the logs delivery (SUCCESS |
         * FAILED).
         * log-destination-type - The type of destination to which the flow
         * log publishes data. Possible destination types include
         * cloud-watch-logs and s3.
         * flow-log-id - The ID of the flow log.
         * log-group-name - The name of the log group.
         * resource-id - The ID of the VPC, subnet, or network interface.
         * traffic-type - The type of traffic (ACCEPT |
         * REJECT | ALL).
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        var filter: List<Filter>?
        /**
         * One or more flow log IDs.
         * Constraint: Maximum of 1000 flow log IDs.
         */
        var flowLogIds: List<String>?
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeFlowLogsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filter: List<Filter>? = null
        override var flowLogIds: List<String>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeFlowLogsRequest) : this() {
            this.dryRun = x.dryRun
            this.filter = x.filter
            this.flowLogIds = x.flowLogIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeFlowLogsRequest = DescribeFlowLogsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filter(filter: List<Filter>): FluentBuilder = apply { this.filter = filter }
        override fun flowLogIds(flowLogIds: List<String>): FluentBuilder = apply { this.flowLogIds = flowLogIds }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
