// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeHostsRequest private constructor(builder: BuilderImpl) {
    /**
     * The filters.
     * auto-placement - Whether auto-placement is enabled or disabled
     * (on | off).
     * availability-zone - The Availability Zone of the
     * host.
     * client-token - The idempotency token that you provided when you
     * allocated the host.
     * host-reservation-id - The ID of the reservation assigned to
     * this host.
     * instance-type - The instance type size that the Dedicated Host
     * is configured to support.
     * state - The allocation state of the Dedicated Host
     * (available | under-assessment |
     * permanent-failure | released |
     * released-permanent-failure).
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    val filter: List<Filter>? = builder.filter
    /**
     * The IDs of the Dedicated Hosts. The IDs are used for targeted instance
     * launches.
     */
    val hostIds: List<String>? = builder.hostIds
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
     * You cannot specify this parameter and the host IDs parameter in the same request.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeHostsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeHostsRequest(")
        append("filter=$filter,")
        append("hostIds=$hostIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (hostIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeHostsRequest

        if (filter != other.filter) return false
        if (hostIds != other.hostIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeHostsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeHostsRequest
        /**
         * The filters.
         * auto-placement - Whether auto-placement is enabled or disabled
         * (on | off).
         * availability-zone - The Availability Zone of the
         * host.
         * client-token - The idempotency token that you provided when you
         * allocated the host.
         * host-reservation-id - The ID of the reservation assigned to
         * this host.
         * instance-type - The instance type size that the Dedicated Host
         * is configured to support.
         * state - The allocation state of the Dedicated Host
         * (available | under-assessment |
         * permanent-failure | released |
         * released-permanent-failure).
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        fun filter(filter: List<Filter>): FluentBuilder
        /**
         * The IDs of the Dedicated Hosts. The IDs are used for targeted instance
         * launches.
         */
        fun hostIds(hostIds: List<String>): FluentBuilder
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
         * You cannot specify this parameter and the host IDs parameter in the same request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to use to retrieve the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The filters.
         * auto-placement - Whether auto-placement is enabled or disabled
         * (on | off).
         * availability-zone - The Availability Zone of the
         * host.
         * client-token - The idempotency token that you provided when you
         * allocated the host.
         * host-reservation-id - The ID of the reservation assigned to
         * this host.
         * instance-type - The instance type size that the Dedicated Host
         * is configured to support.
         * state - The allocation state of the Dedicated Host
         * (available | under-assessment |
         * permanent-failure | released |
         * released-permanent-failure).
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        var filter: List<Filter>?
        /**
         * The IDs of the Dedicated Hosts. The IDs are used for targeted instance
         * launches.
         */
        var hostIds: List<String>?
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error.
         * You cannot specify this parameter and the host IDs parameter in the same request.
         */
        var maxResults: Int?
        /**
         * The token to use to retrieve the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeHostsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var filter: List<Filter>? = null
        override var hostIds: List<String>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeHostsRequest) : this() {
            this.filter = x.filter
            this.hostIds = x.hostIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeHostsRequest = DescribeHostsRequest(this)
        override fun filter(filter: List<Filter>): FluentBuilder = apply { this.filter = filter }
        override fun hostIds(hostIds: List<String>): FluentBuilder = apply { this.hostIds = hostIds }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
