// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeImagesRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Scopes the images by users with explicit launch permissions.
     * Specify an Amazon Web Services account ID, self (the sender of the request),
     * or all (public AMIs).
     */
    val executableUsers: List<String>? = builder.executableUsers
    /**
     * The filters.
     * architecture - The image architecture (i386 |
     * x86_64 | arm64).
     * block-device-mapping.delete-on-termination - A Boolean value that indicates
     * whether the Amazon EBS volume is deleted on instance termination.
     * block-device-mapping.device-name - The device name specified in the block device mapping (for
     * example, /dev/sdh or xvdh).
     * block-device-mapping.snapshot-id - The ID of the snapshot used for the Amazon EBS
     * volume.
     * block-device-mapping.volume-size - The volume size of the Amazon EBS volume, in GiB.
     * block-device-mapping.volume-type - The volume type of the Amazon EBS volume
     * (io1 | io2 | gp2 | gp3 | sc1
     * | st1 | standard).
     * block-device-mapping.encrypted - A Boolean that indicates whether the Amazon EBS volume is encrypted.
     * description - The description of the image (provided during image
     * creation).
     * ena-support - A Boolean that indicates whether enhanced networking
     * with ENA is enabled.
     * hypervisor - The hypervisor type (ovm |
     * xen).
     * image-id - The ID of the image.
     * image-type - The image type (machine | kernel |
     * ramdisk).
     * is-public - A Boolean that indicates whether the image is public.
     * kernel-id - The kernel ID.
     * manifest-location - The location of the image manifest.
     * name - The name of the AMI (provided during image creation).
     * owner-alias - The owner alias (amazon | aws-marketplace).
     * The valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can be
     * set using the IAM console. We recommend that you use the Owner
     * request parameter instead of this filter.
     * owner-id - The Amazon Web Services account ID of the owner. We recommend that you use the
     * Owner request parameter instead of this filter.
     * platform - The platform. To only list Windows-based AMIs, use
     * windows.
     * product-code - The product code.
     * product-code.type - The type of the product code (marketplace).
     * ramdisk-id - The RAM disk ID.
     * root-device-name - The device name of the root device volume (for example, /dev/sda1).
     * root-device-type - The type of the root device volume (ebs |
     * instance-store).
     * state - The state of the image (available | pending
     * | failed).
     * state-reason-code - The reason code for the state change.
     * state-reason-message - The message for the state change.
     * sriov-net-support - A value of simple indicates
     * that enhanced networking with the Intel 82599 VF interface is enabled.
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * virtualization-type - The virtualization type (paravirtual |
     * hvm).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The image IDs.
     * Default: Describes all images available to you.
     */
    val imageIds: List<String>? = builder.imageIds
    /**
     * If true, all deprecated AMIs are included in the response. If
     * false, no deprecated AMIs are included in the response. If no value is
     * specified, the default value is false.
     * If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (true or false) that you set for this parameter.
     */
    val includeDeprecated: Boolean? = builder.includeDeprecated
    /**
     * Scopes the results to images with the specified owners. You can specify a combination of
     * Amazon Web Services account IDs, self, amazon, and aws-marketplace.
     * If you omit this parameter, the results include all images for which you have launch permissions,
     * regardless of ownership.
     */
    val owners: List<String>? = builder.owners

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeImagesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeImagesRequest(")
        append("dryRun=$dryRun,")
        append("executableUsers=$executableUsers,")
        append("filters=$filters,")
        append("imageIds=$imageIds,")
        append("includeDeprecated=$includeDeprecated,")
        append("owners=$owners)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (executableUsers?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (imageIds?.hashCode() ?: 0)
        result = 31 * result + (includeDeprecated?.hashCode() ?: 0)
        result = 31 * result + (owners?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeImagesRequest

        if (dryRun != other.dryRun) return false
        if (executableUsers != other.executableUsers) return false
        if (filters != other.filters) return false
        if (imageIds != other.imageIds) return false
        if (includeDeprecated != other.includeDeprecated) return false
        if (owners != other.owners) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeImagesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeImagesRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Scopes the images by users with explicit launch permissions.
         * Specify an Amazon Web Services account ID, self (the sender of the request),
         * or all (public AMIs).
         */
        fun executableUsers(executableUsers: List<String>): FluentBuilder
        /**
         * The filters.
         * architecture - The image architecture (i386 |
         * x86_64 | arm64).
         * block-device-mapping.delete-on-termination - A Boolean value that indicates
         * whether the Amazon EBS volume is deleted on instance termination.
         * block-device-mapping.device-name - The device name specified in the block device mapping (for
         * example, /dev/sdh or xvdh).
         * block-device-mapping.snapshot-id - The ID of the snapshot used for the Amazon EBS
         * volume.
         * block-device-mapping.volume-size - The volume size of the Amazon EBS volume, in GiB.
         * block-device-mapping.volume-type - The volume type of the Amazon EBS volume
         * (io1 | io2 | gp2 | gp3 | sc1
         * | st1 | standard).
         * block-device-mapping.encrypted - A Boolean that indicates whether the Amazon EBS volume is encrypted.
         * description - The description of the image (provided during image
         * creation).
         * ena-support - A Boolean that indicates whether enhanced networking
         * with ENA is enabled.
         * hypervisor - The hypervisor type (ovm |
         * xen).
         * image-id - The ID of the image.
         * image-type - The image type (machine | kernel |
         * ramdisk).
         * is-public - A Boolean that indicates whether the image is public.
         * kernel-id - The kernel ID.
         * manifest-location - The location of the image manifest.
         * name - The name of the AMI (provided during image creation).
         * owner-alias - The owner alias (amazon | aws-marketplace).
         * The valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can be
         * set using the IAM console. We recommend that you use the Owner
         * request parameter instead of this filter.
         * owner-id - The Amazon Web Services account ID of the owner. We recommend that you use the
         * Owner request parameter instead of this filter.
         * platform - The platform. To only list Windows-based AMIs, use
         * windows.
         * product-code - The product code.
         * product-code.type - The type of the product code (marketplace).
         * ramdisk-id - The RAM disk ID.
         * root-device-name - The device name of the root device volume (for example, /dev/sda1).
         * root-device-type - The type of the root device volume (ebs |
         * instance-store).
         * state - The state of the image (available | pending
         * | failed).
         * state-reason-code - The reason code for the state change.
         * state-reason-message - The message for the state change.
         * sriov-net-support - A value of simple indicates
         * that enhanced networking with the Intel 82599 VF interface is enabled.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * virtualization-type - The virtualization type (paravirtual |
         * hvm).
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The image IDs.
         * Default: Describes all images available to you.
         */
        fun imageIds(imageIds: List<String>): FluentBuilder
        /**
         * If true, all deprecated AMIs are included in the response. If
         * false, no deprecated AMIs are included in the response. If no value is
         * specified, the default value is false.
         * If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (true or false) that you set for this parameter.
         */
        fun includeDeprecated(includeDeprecated: Boolean): FluentBuilder
        /**
         * Scopes the results to images with the specified owners. You can specify a combination of
         * Amazon Web Services account IDs, self, amazon, and aws-marketplace.
         * If you omit this parameter, the results include all images for which you have launch permissions,
         * regardless of ownership.
         */
        fun owners(owners: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Scopes the images by users with explicit launch permissions.
         * Specify an Amazon Web Services account ID, self (the sender of the request),
         * or all (public AMIs).
         */
        var executableUsers: List<String>?
        /**
         * The filters.
         * architecture - The image architecture (i386 |
         * x86_64 | arm64).
         * block-device-mapping.delete-on-termination - A Boolean value that indicates
         * whether the Amazon EBS volume is deleted on instance termination.
         * block-device-mapping.device-name - The device name specified in the block device mapping (for
         * example, /dev/sdh or xvdh).
         * block-device-mapping.snapshot-id - The ID of the snapshot used for the Amazon EBS
         * volume.
         * block-device-mapping.volume-size - The volume size of the Amazon EBS volume, in GiB.
         * block-device-mapping.volume-type - The volume type of the Amazon EBS volume
         * (io1 | io2 | gp2 | gp3 | sc1
         * | st1 | standard).
         * block-device-mapping.encrypted - A Boolean that indicates whether the Amazon EBS volume is encrypted.
         * description - The description of the image (provided during image
         * creation).
         * ena-support - A Boolean that indicates whether enhanced networking
         * with ENA is enabled.
         * hypervisor - The hypervisor type (ovm |
         * xen).
         * image-id - The ID of the image.
         * image-type - The image type (machine | kernel |
         * ramdisk).
         * is-public - A Boolean that indicates whether the image is public.
         * kernel-id - The kernel ID.
         * manifest-location - The location of the image manifest.
         * name - The name of the AMI (provided during image creation).
         * owner-alias - The owner alias (amazon | aws-marketplace).
         * The valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can be
         * set using the IAM console. We recommend that you use the Owner
         * request parameter instead of this filter.
         * owner-id - The Amazon Web Services account ID of the owner. We recommend that you use the
         * Owner request parameter instead of this filter.
         * platform - The platform. To only list Windows-based AMIs, use
         * windows.
         * product-code - The product code.
         * product-code.type - The type of the product code (marketplace).
         * ramdisk-id - The RAM disk ID.
         * root-device-name - The device name of the root device volume (for example, /dev/sda1).
         * root-device-type - The type of the root device volume (ebs |
         * instance-store).
         * state - The state of the image (available | pending
         * | failed).
         * state-reason-code - The reason code for the state change.
         * state-reason-message - The message for the state change.
         * sriov-net-support - A value of simple indicates
         * that enhanced networking with the Intel 82599 VF interface is enabled.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * virtualization-type - The virtualization type (paravirtual |
         * hvm).
         */
        var filters: List<Filter>?
        /**
         * The image IDs.
         * Default: Describes all images available to you.
         */
        var imageIds: List<String>?
        /**
         * If true, all deprecated AMIs are included in the response. If
         * false, no deprecated AMIs are included in the response. If no value is
         * specified, the default value is false.
         * If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (true or false) that you set for this parameter.
         */
        var includeDeprecated: Boolean?
        /**
         * Scopes the results to images with the specified owners. You can specify a combination of
         * Amazon Web Services account IDs, self, amazon, and aws-marketplace.
         * If you omit this parameter, the results include all images for which you have launch permissions,
         * regardless of ownership.
         */
        var owners: List<String>?

        fun build(): DescribeImagesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var executableUsers: List<String>? = null
        override var filters: List<Filter>? = null
        override var imageIds: List<String>? = null
        override var includeDeprecated: Boolean? = null
        override var owners: List<String>? = null

        constructor(x: DescribeImagesRequest) : this() {
            this.dryRun = x.dryRun
            this.executableUsers = x.executableUsers
            this.filters = x.filters
            this.imageIds = x.imageIds
            this.includeDeprecated = x.includeDeprecated
            this.owners = x.owners
        }

        override fun build(): DescribeImagesRequest = DescribeImagesRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun executableUsers(executableUsers: List<String>): FluentBuilder = apply { this.executableUsers = executableUsers }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun imageIds(imageIds: List<String>): FluentBuilder = apply { this.imageIds = imageIds }
        override fun includeDeprecated(includeDeprecated: Boolean): FluentBuilder = apply { this.includeDeprecated = includeDeprecated }
        override fun owners(owners: List<String>): FluentBuilder = apply { this.owners = owners }
    }
}
