// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an instance attribute.
 */
class DescribeInstanceAttributeResponse private constructor(builder: BuilderImpl) {
    /**
     * The block device mapping of the instance.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * If the value is true, you can't terminate the instance through the Amazon
     * EC2 console, CLI, or API; otherwise, you can.
     */
    val disableApiTermination: AttributeBooleanValue? = builder.disableApiTermination
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     */
    val ebsOptimized: AttributeBooleanValue? = builder.ebsOptimized
    /**
     * Indicates whether enhanced networking with ENA is enabled.
     */
    val enaSupport: AttributeBooleanValue? = builder.enaSupport
    /**
     * To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to true; otherwise,
     * set it to false.
     */
    val enclaveOptions: EnclaveOptions? = builder.enclaveOptions
    /**
     * The security groups associated with the instance.
     */
    val groups: List<GroupIdentifier>? = builder.groups
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the
     * instance (using the operating system command for system shutdown).
     */
    val instanceInitiatedShutdownBehavior: AttributeValue? = builder.instanceInitiatedShutdownBehavior
    /**
     * The instance type.
     */
    val instanceType: AttributeValue? = builder.instanceType
    /**
     * The kernel ID.
     */
    val kernelId: AttributeValue? = builder.kernelId
    /**
     * A list of product codes.
     */
    val productCodes: List<ProductCode>? = builder.productCodes
    /**
     * The RAM disk ID.
     */
    val ramdiskId: AttributeValue? = builder.ramdiskId
    /**
     * The device name of the root device volume (for example,
     * /dev/sda1).
     */
    val rootDeviceName: AttributeValue? = builder.rootDeviceName
    /**
     * Enable or disable source/destination checks, which ensure that the instance
     * is either the source or the destination of any traffic that it receives.
     * If the value is true, source/destination checks are enabled;
     * otherwise, they are disabled. The default value is true.
     * You must disable source/destination checks if the instance runs services
     * such as network address translation, routing, or firewalls.
     */
    val sourceDestCheck: AttributeBooleanValue? = builder.sourceDestCheck
    /**
     * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface
     * is enabled.
     */
    val sriovNetSupport: AttributeValue? = builder.sriovNetSupport
    /**
     * The user data.
     */
    val userData: AttributeValue? = builder.userData

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeInstanceAttributeResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInstanceAttributeResponse(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("disableApiTermination=$disableApiTermination,")
        append("ebsOptimized=$ebsOptimized,")
        append("enaSupport=$enaSupport,")
        append("enclaveOptions=$enclaveOptions,")
        append("groups=$groups,")
        append("instanceId=$instanceId,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("productCodes=$productCodes,")
        append("ramdiskId=$ramdiskId,")
        append("rootDeviceName=$rootDeviceName,")
        append("sourceDestCheck=$sourceDestCheck,")
        append("sriovNetSupport=$sriovNetSupport,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (disableApiTermination?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (productCodes?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceName?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        result = 31 * result + (sriovNetSupport?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeInstanceAttributeResponse

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (disableApiTermination != other.disableApiTermination) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (enaSupport != other.enaSupport) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (groups != other.groups) return false
        if (instanceId != other.instanceId) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (productCodes != other.productCodes) return false
        if (ramdiskId != other.ramdiskId) return false
        if (rootDeviceName != other.rootDeviceName) return false
        if (sourceDestCheck != other.sourceDestCheck) return false
        if (sriovNetSupport != other.sriovNetSupport) return false
        if (userData != other.userData) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeInstanceAttributeResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeInstanceAttributeResponse
        /**
         * The block device mapping of the instance.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder
        /**
         * If the value is true, you can't terminate the instance through the Amazon
         * EC2 console, CLI, or API; otherwise, you can.
         */
        fun disableApiTermination(disableApiTermination: AttributeBooleanValue): FluentBuilder
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         */
        fun ebsOptimized(ebsOptimized: AttributeBooleanValue): FluentBuilder
        /**
         * Indicates whether enhanced networking with ENA is enabled.
         */
        fun enaSupport(enaSupport: AttributeBooleanValue): FluentBuilder
        /**
         * To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to true; otherwise,
         * set it to false.
         */
        fun enclaveOptions(enclaveOptions: EnclaveOptions): FluentBuilder
        /**
         * The security groups associated with the instance.
         */
        fun groups(groups: List<GroupIdentifier>): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the
         * instance (using the operating system command for system shutdown).
         */
        fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: AttributeValue): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: AttributeValue): FluentBuilder
        /**
         * The kernel ID.
         */
        fun kernelId(kernelId: AttributeValue): FluentBuilder
        /**
         * A list of product codes.
         */
        fun productCodes(productCodes: List<ProductCode>): FluentBuilder
        /**
         * The RAM disk ID.
         */
        fun ramdiskId(ramdiskId: AttributeValue): FluentBuilder
        /**
         * The device name of the root device volume (for example,
         * /dev/sda1).
         */
        fun rootDeviceName(rootDeviceName: AttributeValue): FluentBuilder
        /**
         * Enable or disable source/destination checks, which ensure that the instance
         * is either the source or the destination of any traffic that it receives.
         * If the value is true, source/destination checks are enabled;
         * otherwise, they are disabled. The default value is true.
         * You must disable source/destination checks if the instance runs services
         * such as network address translation, routing, or firewalls.
         */
        fun sourceDestCheck(sourceDestCheck: AttributeBooleanValue): FluentBuilder
        /**
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface
         * is enabled.
         */
        fun sriovNetSupport(sriovNetSupport: AttributeValue): FluentBuilder
        /**
         * The user data.
         */
        fun userData(userData: AttributeValue): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The block device mapping of the instance.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMapping>?
        /**
         * If the value is true, you can't terminate the instance through the Amazon
         * EC2 console, CLI, or API; otherwise, you can.
         */
        var disableApiTermination: AttributeBooleanValue?
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         */
        var ebsOptimized: AttributeBooleanValue?
        /**
         * Indicates whether enhanced networking with ENA is enabled.
         */
        var enaSupport: AttributeBooleanValue?
        /**
         * To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to true; otherwise,
         * set it to false.
         */
        var enclaveOptions: EnclaveOptions?
        /**
         * The security groups associated with the instance.
         */
        var groups: List<GroupIdentifier>?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the
         * instance (using the operating system command for system shutdown).
         */
        var instanceInitiatedShutdownBehavior: AttributeValue?
        /**
         * The instance type.
         */
        var instanceType: AttributeValue?
        /**
         * The kernel ID.
         */
        var kernelId: AttributeValue?
        /**
         * A list of product codes.
         */
        var productCodes: List<ProductCode>?
        /**
         * The RAM disk ID.
         */
        var ramdiskId: AttributeValue?
        /**
         * The device name of the root device volume (for example,
         * /dev/sda1).
         */
        var rootDeviceName: AttributeValue?
        /**
         * Enable or disable source/destination checks, which ensure that the instance
         * is either the source or the destination of any traffic that it receives.
         * If the value is true, source/destination checks are enabled;
         * otherwise, they are disabled. The default value is true.
         * You must disable source/destination checks if the instance runs services
         * such as network address translation, routing, or firewalls.
         */
        var sourceDestCheck: AttributeBooleanValue?
        /**
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface
         * is enabled.
         */
        var sriovNetSupport: AttributeValue?
        /**
         * The user data.
         */
        var userData: AttributeValue?

        fun build(): DescribeInstanceAttributeResponse
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun disableApiTermination(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.disableApiTermination = AttributeBooleanValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun ebsOptimized(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.ebsOptimized = AttributeBooleanValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun enaSupport(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.enaSupport = AttributeBooleanValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EnclaveOptions] inside the given [block]
         */
        fun enclaveOptions(block: EnclaveOptions.DslBuilder.() -> kotlin.Unit) {
            this.enclaveOptions = EnclaveOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun instanceInitiatedShutdownBehavior(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.instanceInitiatedShutdownBehavior = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun instanceType(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.instanceType = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun kernelId(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.kernelId = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun ramdiskId(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.ramdiskId = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun rootDeviceName(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.rootDeviceName = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun sourceDestCheck(block: AttributeBooleanValue.DslBuilder.() -> kotlin.Unit) {
            this.sourceDestCheck = AttributeBooleanValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun sriovNetSupport(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.sriovNetSupport = AttributeValue.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun userData(block: AttributeValue.DslBuilder.() -> kotlin.Unit) {
            this.userData = AttributeValue.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        override var disableApiTermination: AttributeBooleanValue? = null
        override var ebsOptimized: AttributeBooleanValue? = null
        override var enaSupport: AttributeBooleanValue? = null
        override var enclaveOptions: EnclaveOptions? = null
        override var groups: List<GroupIdentifier>? = null
        override var instanceId: String? = null
        override var instanceInitiatedShutdownBehavior: AttributeValue? = null
        override var instanceType: AttributeValue? = null
        override var kernelId: AttributeValue? = null
        override var productCodes: List<ProductCode>? = null
        override var ramdiskId: AttributeValue? = null
        override var rootDeviceName: AttributeValue? = null
        override var sourceDestCheck: AttributeBooleanValue? = null
        override var sriovNetSupport: AttributeValue? = null
        override var userData: AttributeValue? = null

        constructor(x: DescribeInstanceAttributeResponse) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.disableApiTermination = x.disableApiTermination
            this.ebsOptimized = x.ebsOptimized
            this.enaSupport = x.enaSupport
            this.enclaveOptions = x.enclaveOptions
            this.groups = x.groups
            this.instanceId = x.instanceId
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.productCodes = x.productCodes
            this.ramdiskId = x.ramdiskId
            this.rootDeviceName = x.rootDeviceName
            this.sourceDestCheck = x.sourceDestCheck
            this.sriovNetSupport = x.sriovNetSupport
            this.userData = x.userData
        }

        override fun build(): DescribeInstanceAttributeResponse = DescribeInstanceAttributeResponse(this)
        override fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun disableApiTermination(disableApiTermination: AttributeBooleanValue): FluentBuilder = apply { this.disableApiTermination = disableApiTermination }
        override fun ebsOptimized(ebsOptimized: AttributeBooleanValue): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun enaSupport(enaSupport: AttributeBooleanValue): FluentBuilder = apply { this.enaSupport = enaSupport }
        override fun enclaveOptions(enclaveOptions: EnclaveOptions): FluentBuilder = apply { this.enclaveOptions = enclaveOptions }
        override fun groups(groups: List<GroupIdentifier>): FluentBuilder = apply { this.groups = groups }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: AttributeValue): FluentBuilder = apply { this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior }
        override fun instanceType(instanceType: AttributeValue): FluentBuilder = apply { this.instanceType = instanceType }
        override fun kernelId(kernelId: AttributeValue): FluentBuilder = apply { this.kernelId = kernelId }
        override fun productCodes(productCodes: List<ProductCode>): FluentBuilder = apply { this.productCodes = productCodes }
        override fun ramdiskId(ramdiskId: AttributeValue): FluentBuilder = apply { this.ramdiskId = ramdiskId }
        override fun rootDeviceName(rootDeviceName: AttributeValue): FluentBuilder = apply { this.rootDeviceName = rootDeviceName }
        override fun sourceDestCheck(sourceDestCheck: AttributeBooleanValue): FluentBuilder = apply { this.sourceDestCheck = sourceDestCheck }
        override fun sriovNetSupport(sriovNetSupport: AttributeValue): FluentBuilder = apply { this.sriovNetSupport = sriovNetSupport }
        override fun userData(userData: AttributeValue): FluentBuilder = apply { this.userData = userData }
    }
}
