// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * <para>Describe instance event windows by InstanceEventWindow.</para>
 */
class DescribeInstanceEventWindowsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * dedicated-host-id - The event windows associated with the specified
     * Dedicated Host ID.
     * event-window-name - The event windows associated with the specified
     * names.
     * instance-id - The event windows associated with the specified instance
     * ID.
     * instance-tag - The event windows associated with the specified tag and
     * value.
     * instance-tag-key - The event windows associated with the specified tag
     * key, regardless of the value.
     * instance-tag-value - The event windows associated with the specified tag
     * value, regardless of the key.
     * tag:<key> - The key/value combination of a tag assigned to the
     * event window. Use the tag key in the filter name and the tag value as the filter
     * value. For example, to find all resources that have a tag with the key
     * Owner and the value CMX, specify tag:Owner
     * for the filter name and CMX for the filter value.
     * tag-key - The key of a tag assigned to the event window. Use this filter
     * to find all event windows that have a tag with a specific key, regardless of the tag
     * value.
     * tag-value - The value of a tag assigned to the event window. Use this
     * filter to find all event windows that have a tag with a specific value, regardless of
     * the tag key.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The IDs of the event windows.
     */
    val instanceEventWindowIds: List<String>? = builder.instanceEventWindowIds
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining
     * results, make another call with the returned NextToken value. This value can
     * be between 20 and 500. You cannot specify this parameter and the event window IDs parameter
     * in the same call.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to request the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeInstanceEventWindowsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInstanceEventWindowsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("instanceEventWindowIds=$instanceEventWindowIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (instanceEventWindowIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeInstanceEventWindowsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (instanceEventWindowIds != other.instanceEventWindowIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeInstanceEventWindowsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeInstanceEventWindowsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * dedicated-host-id - The event windows associated with the specified
         * Dedicated Host ID.
         * event-window-name - The event windows associated with the specified
         * names.
         * instance-id - The event windows associated with the specified instance
         * ID.
         * instance-tag - The event windows associated with the specified tag and
         * value.
         * instance-tag-key - The event windows associated with the specified tag
         * key, regardless of the value.
         * instance-tag-value - The event windows associated with the specified tag
         * value, regardless of the key.
         * tag:<key> - The key/value combination of a tag assigned to the
         * event window. Use the tag key in the filter name and the tag value as the filter
         * value. For example, to find all resources that have a tag with the key
         * Owner and the value CMX, specify tag:Owner
         * for the filter name and CMX for the filter value.
         * tag-key - The key of a tag assigned to the event window. Use this filter
         * to find all event windows that have a tag with a specific key, regardless of the tag
         * value.
         * tag-value - The value of a tag assigned to the event window. Use this
         * filter to find all event windows that have a tag with a specific value, regardless of
         * the tag key.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The IDs of the event windows.
         */
        fun instanceEventWindowIds(instanceEventWindowIds: List<String>): FluentBuilder
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value. This value can
         * be between 20 and 500. You cannot specify this parameter and the event window IDs parameter
         * in the same call.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to request the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * dedicated-host-id - The event windows associated with the specified
         * Dedicated Host ID.
         * event-window-name - The event windows associated with the specified
         * names.
         * instance-id - The event windows associated with the specified instance
         * ID.
         * instance-tag - The event windows associated with the specified tag and
         * value.
         * instance-tag-key - The event windows associated with the specified tag
         * key, regardless of the value.
         * instance-tag-value - The event windows associated with the specified tag
         * value, regardless of the key.
         * tag:<key> - The key/value combination of a tag assigned to the
         * event window. Use the tag key in the filter name and the tag value as the filter
         * value. For example, to find all resources that have a tag with the key
         * Owner and the value CMX, specify tag:Owner
         * for the filter name and CMX for the filter value.
         * tag-key - The key of a tag assigned to the event window. Use this filter
         * to find all event windows that have a tag with a specific key, regardless of the tag
         * value.
         * tag-value - The value of a tag assigned to the event window. Use this
         * filter to find all event windows that have a tag with a specific value, regardless of
         * the tag key.
         */
        var filters: List<Filter>?
        /**
         * The IDs of the event windows.
         */
        var instanceEventWindowIds: List<String>?
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value. This value can
         * be between 20 and 500. You cannot specify this parameter and the event window IDs parameter
         * in the same call.
         */
        var maxResults: Int?
        /**
         * The token to request the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeInstanceEventWindowsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var instanceEventWindowIds: List<String>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeInstanceEventWindowsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.instanceEventWindowIds = x.instanceEventWindowIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeInstanceEventWindowsRequest = DescribeInstanceEventWindowsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun instanceEventWindowIds(instanceEventWindowIds: List<String>): FluentBuilder = apply { this.instanceEventWindowIds = instanceEventWindowIds }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
