// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeInstanceStatusRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The filters.
     * availability-zone - The Availability Zone of the instance.
     * event.code - The code for the scheduled event
     * (instance-reboot | system-reboot |
     * system-maintenance | instance-retirement |
     * instance-stop).
     * event.description - A description of the event.
     * event.instance-event-id - The ID of the event whose date and time
     * you are modifying.
     * event.not-after - The latest end time for the scheduled event
     * (for example, 2014-09-15T17:15:20.000Z).
     * event.not-before - The earliest start time for the scheduled
     * event (for example, 2014-09-15T17:15:20.000Z).
     * event.not-before-deadline - The deadline for starting the event
     * (for example, 2014-09-15T17:15:20.000Z).
     * instance-state-code - The code for the instance state, as a
     * 16-bit unsigned integer. The high byte is used for internal purposes and should
     * be ignored. The low byte is set based on the state represented. The valid values
     * are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
     * (stopping), and 80 (stopped).
     * instance-state-name - The state of the instance
     * (pending | running | shutting-down |
     * terminated | stopping |
     * stopped).
     * instance-status.reachability - Filters on instance status where
     * the name is reachability (passed | failed
     * | initializing | insufficient-data).
     * instance-status.status - The status of the instance
     * (ok | impaired | initializing |
     * insufficient-data | not-applicable).
     * system-status.reachability - Filters on system status where the
     * name is reachability (passed | failed |
     * initializing | insufficient-data).
     * system-status.status - The system status of the instance
     * (ok | impaired | initializing |
     * insufficient-data | not-applicable).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * When true, includes the health status for all instances. When
     * false, includes the health status for running instances only.
     * Default: false
     */
    val includeAllInstances: Boolean? = builder.includeAllInstances
    /**
     * The instance IDs.
     * Default: Describes all your instances.
     * Constraints: Maximum 100 explicitly specified instance IDs.
     */
    val instanceIds: List<String>? = builder.instanceIds
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining
     * results, make another call with the returned NextToken value. This value
     * can be between 5 and 1000. You cannot specify this parameter and the instance IDs
     * parameter in the same call.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to retrieve the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeInstanceStatusRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInstanceStatusRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("includeAllInstances=$includeAllInstances,")
        append("instanceIds=$instanceIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includeAllInstances?.hashCode() ?: 0)
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeInstanceStatusRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (includeAllInstances != other.includeAllInstances) return false
        if (instanceIds != other.instanceIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeInstanceStatusRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeInstanceStatusRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The filters.
         * availability-zone - The Availability Zone of the instance.
         * event.code - The code for the scheduled event
         * (instance-reboot | system-reboot |
         * system-maintenance | instance-retirement |
         * instance-stop).
         * event.description - A description of the event.
         * event.instance-event-id - The ID of the event whose date and time
         * you are modifying.
         * event.not-after - The latest end time for the scheduled event
         * (for example, 2014-09-15T17:15:20.000Z).
         * event.not-before - The earliest start time for the scheduled
         * event (for example, 2014-09-15T17:15:20.000Z).
         * event.not-before-deadline - The deadline for starting the event
         * (for example, 2014-09-15T17:15:20.000Z).
         * instance-state-code - The code for the instance state, as a
         * 16-bit unsigned integer. The high byte is used for internal purposes and should
         * be ignored. The low byte is set based on the state represented. The valid values
         * are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         * (stopping), and 80 (stopped).
         * instance-state-name - The state of the instance
         * (pending | running | shutting-down |
         * terminated | stopping |
         * stopped).
         * instance-status.reachability - Filters on instance status where
         * the name is reachability (passed | failed
         * | initializing | insufficient-data).
         * instance-status.status - The status of the instance
         * (ok | impaired | initializing |
         * insufficient-data | not-applicable).
         * system-status.reachability - Filters on system status where the
         * name is reachability (passed | failed |
         * initializing | insufficient-data).
         * system-status.status - The system status of the instance
         * (ok | impaired | initializing |
         * insufficient-data | not-applicable).
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * When true, includes the health status for all instances. When
         * false, includes the health status for running instances only.
         * Default: false
         */
        fun includeAllInstances(includeAllInstances: Boolean): FluentBuilder
        /**
         * The instance IDs.
         * Default: Describes all your instances.
         * Constraints: Maximum 100 explicitly specified instance IDs.
         */
        fun instanceIds(instanceIds: List<String>): FluentBuilder
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value. This value
         * can be between 5 and 1000. You cannot specify this parameter and the instance IDs
         * parameter in the same call.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to retrieve the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The filters.
         * availability-zone - The Availability Zone of the instance.
         * event.code - The code for the scheduled event
         * (instance-reboot | system-reboot |
         * system-maintenance | instance-retirement |
         * instance-stop).
         * event.description - A description of the event.
         * event.instance-event-id - The ID of the event whose date and time
         * you are modifying.
         * event.not-after - The latest end time for the scheduled event
         * (for example, 2014-09-15T17:15:20.000Z).
         * event.not-before - The earliest start time for the scheduled
         * event (for example, 2014-09-15T17:15:20.000Z).
         * event.not-before-deadline - The deadline for starting the event
         * (for example, 2014-09-15T17:15:20.000Z).
         * instance-state-code - The code for the instance state, as a
         * 16-bit unsigned integer. The high byte is used for internal purposes and should
         * be ignored. The low byte is set based on the state represented. The valid values
         * are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         * (stopping), and 80 (stopped).
         * instance-state-name - The state of the instance
         * (pending | running | shutting-down |
         * terminated | stopping |
         * stopped).
         * instance-status.reachability - Filters on instance status where
         * the name is reachability (passed | failed
         * | initializing | insufficient-data).
         * instance-status.status - The status of the instance
         * (ok | impaired | initializing |
         * insufficient-data | not-applicable).
         * system-status.reachability - Filters on system status where the
         * name is reachability (passed | failed |
         * initializing | insufficient-data).
         * system-status.status - The system status of the instance
         * (ok | impaired | initializing |
         * insufficient-data | not-applicable).
         */
        var filters: List<Filter>?
        /**
         * When true, includes the health status for all instances. When
         * false, includes the health status for running instances only.
         * Default: false
         */
        var includeAllInstances: Boolean?
        /**
         * The instance IDs.
         * Default: Describes all your instances.
         * Constraints: Maximum 100 explicitly specified instance IDs.
         */
        var instanceIds: List<String>?
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value. This value
         * can be between 5 and 1000. You cannot specify this parameter and the instance IDs
         * parameter in the same call.
         */
        var maxResults: Int?
        /**
         * The token to retrieve the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeInstanceStatusRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var includeAllInstances: Boolean? = null
        override var instanceIds: List<String>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeInstanceStatusRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.includeAllInstances = x.includeAllInstances
            this.instanceIds = x.instanceIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeInstanceStatusRequest = DescribeInstanceStatusRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun includeAllInstances(includeAllInstances: Boolean): FluentBuilder = apply { this.includeAllInstances = includeAllInstances }
        override fun instanceIds(instanceIds: List<String>): FluentBuilder = apply { this.instanceIds = instanceIds }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
