// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeInternetGatewaysRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * attachment.state - The current state of the attachment between the gateway
     * and the VPC (available). Present only if a VPC is attached.
     * attachment.vpc-id - The ID of an attached VPC.
     * internet-gateway-id - The ID of the Internet gateway.
     * owner-id - The ID of the Amazon Web Services account that owns the internet gateway.
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * One or more internet gateway IDs.
     * Default: Describes all your internet gateways.
     */
    val internetGatewayIds: List<String>? = builder.internetGatewayIds
    /**
     * The maximum number of results to return with a single call.
     * To retrieve the remaining results, make another call with the returned nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeInternetGatewaysRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInternetGatewaysRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("internetGatewayIds=$internetGatewayIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (internetGatewayIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeInternetGatewaysRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (internetGatewayIds != other.internetGatewayIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeInternetGatewaysRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeInternetGatewaysRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * attachment.state - The current state of the attachment between the gateway
         * and the VPC (available). Present only if a VPC is attached.
         * attachment.vpc-id - The ID of an attached VPC.
         * internet-gateway-id - The ID of the Internet gateway.
         * owner-id - The ID of the Amazon Web Services account that owns the internet gateway.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * One or more internet gateway IDs.
         * Default: Describes all your internet gateways.
         */
        fun internetGatewayIds(internetGatewayIds: List<String>): FluentBuilder
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * attachment.state - The current state of the attachment between the gateway
         * and the VPC (available). Present only if a VPC is attached.
         * attachment.vpc-id - The ID of an attached VPC.
         * internet-gateway-id - The ID of the Internet gateway.
         * owner-id - The ID of the Amazon Web Services account that owns the internet gateway.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        var filters: List<Filter>?
        /**
         * One or more internet gateway IDs.
         * Default: Describes all your internet gateways.
         */
        var internetGatewayIds: List<String>?
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeInternetGatewaysRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var internetGatewayIds: List<String>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeInternetGatewaysRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.internetGatewayIds = x.internetGatewayIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeInternetGatewaysRequest = DescribeInternetGatewaysRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun internetGatewayIds(internetGatewayIds: List<String>): FluentBuilder = apply { this.internetGatewayIds = internetGatewayIds }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
