// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeLaunchTemplateVersionsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * create-time - The time the launch template version was created.
     * ebs-optimized - A boolean that indicates whether the instance
     * is optimized for Amazon EBS I/O.
     * iam-instance-profile - The ARN of the IAM instance
     * profile.
     * image-id - The ID of the AMI.
     * instance-type - The instance type.
     * is-default-version - A boolean that indicates whether the
     * launch template version is the default version.
     * kernel-id - The kernel ID.
     * ram-disk-id - The RAM disk ID.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The ID of the launch template. To describe one or more versions of a specified launch
     * template, you must specify either the launch template ID or the launch template name in
     * the request. To describe all the latest or default launch template versions in your
     * account, you must omit this parameter.
     */
    val launchTemplateId: String? = builder.launchTemplateId
    /**
     * The name of the launch template. To describe one or more versions of a specified
     * launch template, you must specify either the launch template ID or the launch template
     * name in the request. To describe all the latest or default launch template versions in
     * your account, you must omit this parameter.
     */
    val launchTemplateName: String? = builder.launchTemplateName
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining
     * results, make another call with the returned NextToken value. This value
     * can be between 1 and 200.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The version number up to which to describe launch template versions.
     */
    val maxVersion: String? = builder.maxVersion
    /**
     * The version number after which to describe launch template versions.
     */
    val minVersion: String? = builder.minVersion
    /**
     * The token to request the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * One or more versions of the launch template. Valid values depend on whether you are describing a specified launch template (by ID or name) or all launch templates in your account.
     * To describe one or more versions of a specified launch template, valid values are $Latest, $Default, and numbers.
     * To describe all launch templates in your account that are defined as the latest
     * version, the valid value is $Latest. To describe all launch templates in
     * your account that are defined as the default version, the valid value is
     * $Default. You can specify $Latest and
     * $Default in the same call. You cannot specify numbers.
     */
    val versions: List<String>? = builder.versions

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeLaunchTemplateVersionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLaunchTemplateVersionsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("maxResults=$maxResults,")
        append("maxVersion=$maxVersion,")
        append("minVersion=$minVersion,")
        append("nextToken=$nextToken,")
        append("versions=$versions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateId?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (maxVersion?.hashCode() ?: 0)
        result = 31 * result + (minVersion?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeLaunchTemplateVersionsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (maxResults != other.maxResults) return false
        if (maxVersion != other.maxVersion) return false
        if (minVersion != other.minVersion) return false
        if (nextToken != other.nextToken) return false
        if (versions != other.versions) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeLaunchTemplateVersionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeLaunchTemplateVersionsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * create-time - The time the launch template version was created.
         * ebs-optimized - A boolean that indicates whether the instance
         * is optimized for Amazon EBS I/O.
         * iam-instance-profile - The ARN of the IAM instance
         * profile.
         * image-id - The ID of the AMI.
         * instance-type - The instance type.
         * is-default-version - A boolean that indicates whether the
         * launch template version is the default version.
         * kernel-id - The kernel ID.
         * ram-disk-id - The RAM disk ID.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The ID of the launch template. To describe one or more versions of a specified launch
         * template, you must specify either the launch template ID or the launch template name in
         * the request. To describe all the latest or default launch template versions in your
         * account, you must omit this parameter.
         */
        fun launchTemplateId(launchTemplateId: String): FluentBuilder
        /**
         * The name of the launch template. To describe one or more versions of a specified
         * launch template, you must specify either the launch template ID or the launch template
         * name in the request. To describe all the latest or default launch template versions in
         * your account, you must omit this parameter.
         */
        fun launchTemplateName(launchTemplateName: String): FluentBuilder
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value. This value
         * can be between 1 and 200.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The version number up to which to describe launch template versions.
         */
        fun maxVersion(maxVersion: String): FluentBuilder
        /**
         * The version number after which to describe launch template versions.
         */
        fun minVersion(minVersion: String): FluentBuilder
        /**
         * The token to request the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * One or more versions of the launch template. Valid values depend on whether you are describing a specified launch template (by ID or name) or all launch templates in your account.
         * To describe one or more versions of a specified launch template, valid values are $Latest, $Default, and numbers.
         * To describe all launch templates in your account that are defined as the latest
         * version, the valid value is $Latest. To describe all launch templates in
         * your account that are defined as the default version, the valid value is
         * $Default. You can specify $Latest and
         * $Default in the same call. You cannot specify numbers.
         */
        fun versions(versions: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * create-time - The time the launch template version was created.
         * ebs-optimized - A boolean that indicates whether the instance
         * is optimized for Amazon EBS I/O.
         * iam-instance-profile - The ARN of the IAM instance
         * profile.
         * image-id - The ID of the AMI.
         * instance-type - The instance type.
         * is-default-version - A boolean that indicates whether the
         * launch template version is the default version.
         * kernel-id - The kernel ID.
         * ram-disk-id - The RAM disk ID.
         */
        var filters: List<Filter>?
        /**
         * The ID of the launch template. To describe one or more versions of a specified launch
         * template, you must specify either the launch template ID or the launch template name in
         * the request. To describe all the latest or default launch template versions in your
         * account, you must omit this parameter.
         */
        var launchTemplateId: String?
        /**
         * The name of the launch template. To describe one or more versions of a specified
         * launch template, you must specify either the launch template ID or the launch template
         * name in the request. To describe all the latest or default launch template versions in
         * your account, you must omit this parameter.
         */
        var launchTemplateName: String?
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value. This value
         * can be between 1 and 200.
         */
        var maxResults: Int?
        /**
         * The version number up to which to describe launch template versions.
         */
        var maxVersion: String?
        /**
         * The version number after which to describe launch template versions.
         */
        var minVersion: String?
        /**
         * The token to request the next page of results.
         */
        var nextToken: String?
        /**
         * One or more versions of the launch template. Valid values depend on whether you are describing a specified launch template (by ID or name) or all launch templates in your account.
         * To describe one or more versions of a specified launch template, valid values are $Latest, $Default, and numbers.
         * To describe all launch templates in your account that are defined as the latest
         * version, the valid value is $Latest. To describe all launch templates in
         * your account that are defined as the default version, the valid value is
         * $Default. You can specify $Latest and
         * $Default in the same call. You cannot specify numbers.
         */
        var versions: List<String>?

        fun build(): DescribeLaunchTemplateVersionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var launchTemplateId: String? = null
        override var launchTemplateName: String? = null
        override var maxResults: Int? = null
        override var maxVersion: String? = null
        override var minVersion: String? = null
        override var nextToken: String? = null
        override var versions: List<String>? = null

        constructor(x: DescribeLaunchTemplateVersionsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.maxResults = x.maxResults
            this.maxVersion = x.maxVersion
            this.minVersion = x.minVersion
            this.nextToken = x.nextToken
            this.versions = x.versions
        }

        override fun build(): DescribeLaunchTemplateVersionsRequest = DescribeLaunchTemplateVersionsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun launchTemplateId(launchTemplateId: String): FluentBuilder = apply { this.launchTemplateId = launchTemplateId }
        override fun launchTemplateName(launchTemplateName: String): FluentBuilder = apply { this.launchTemplateName = launchTemplateName }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun maxVersion(maxVersion: String): FluentBuilder = apply { this.maxVersion = maxVersion }
        override fun minVersion(minVersion: String): FluentBuilder = apply { this.minVersion = minVersion }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun versions(versions: List<String>): FluentBuilder = apply { this.versions = versions }
    }
}
