// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeNetworkInsightsAnalysesRequest private constructor(builder: BuilderImpl) {
    /**
     * The time when the network insights analyses ended.
     */
    val analysisEndTime: Instant? = builder.analysisEndTime
    /**
     * The time when the network insights analyses started.
     */
    val analysisStartTime: Instant? = builder.analysisStartTime
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The filters. The following are possible values:
     * PathFound - A Boolean value that indicates whether a feasible path is found.
     * Status - The status of the analysis (running | succeeded | failed).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call.
     * To retrieve the remaining results, make another call with the returned nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
     */
    val networkInsightsAnalysisIds: List<String>? = builder.networkInsightsAnalysisIds
    /**
     * The ID of the path. You must specify either a path ID or analysis IDs.
     */
    val networkInsightsPathId: String? = builder.networkInsightsPathId
    /**
     * The token for the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeNetworkInsightsAnalysesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeNetworkInsightsAnalysesRequest(")
        append("analysisEndTime=$analysisEndTime,")
        append("analysisStartTime=$analysisStartTime,")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("networkInsightsAnalysisIds=$networkInsightsAnalysisIds,")
        append("networkInsightsPathId=$networkInsightsPathId,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisEndTime?.hashCode() ?: 0
        result = 31 * result + (analysisStartTime?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (networkInsightsAnalysisIds?.hashCode() ?: 0)
        result = 31 * result + (networkInsightsPathId?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeNetworkInsightsAnalysesRequest

        if (analysisEndTime != other.analysisEndTime) return false
        if (analysisStartTime != other.analysisStartTime) return false
        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (networkInsightsAnalysisIds != other.networkInsightsAnalysisIds) return false
        if (networkInsightsPathId != other.networkInsightsPathId) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeNetworkInsightsAnalysesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeNetworkInsightsAnalysesRequest
        /**
         * The time when the network insights analyses ended.
         */
        fun analysisEndTime(analysisEndTime: Instant): FluentBuilder
        /**
         * The time when the network insights analyses started.
         */
        fun analysisStartTime(analysisStartTime: Instant): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The filters. The following are possible values:
         * PathFound - A Boolean value that indicates whether a feasible path is found.
         * Status - The status of the analysis (running | succeeded | failed).
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
         */
        fun networkInsightsAnalysisIds(networkInsightsAnalysisIds: List<String>): FluentBuilder
        /**
         * The ID of the path. You must specify either a path ID or analysis IDs.
         */
        fun networkInsightsPathId(networkInsightsPathId: String): FluentBuilder
        /**
         * The token for the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time when the network insights analyses ended.
         */
        var analysisEndTime: Instant?
        /**
         * The time when the network insights analyses started.
         */
        var analysisStartTime: Instant?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The filters. The following are possible values:
         * PathFound - A Boolean value that indicates whether a feasible path is found.
         * Status - The status of the analysis (running | succeeded | failed).
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        var maxResults: Int?
        /**
         * The ID of the network insights analyses. You must specify either analysis IDs or a path ID.
         */
        var networkInsightsAnalysisIds: List<String>?
        /**
         * The ID of the path. You must specify either a path ID or analysis IDs.
         */
        var networkInsightsPathId: String?
        /**
         * The token for the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeNetworkInsightsAnalysesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analysisEndTime: Instant? = null
        override var analysisStartTime: Instant? = null
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var networkInsightsAnalysisIds: List<String>? = null
        override var networkInsightsPathId: String? = null
        override var nextToken: String? = null

        constructor(x: DescribeNetworkInsightsAnalysesRequest) : this() {
            this.analysisEndTime = x.analysisEndTime
            this.analysisStartTime = x.analysisStartTime
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.networkInsightsAnalysisIds = x.networkInsightsAnalysisIds
            this.networkInsightsPathId = x.networkInsightsPathId
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeNetworkInsightsAnalysesRequest = DescribeNetworkInsightsAnalysesRequest(this)
        override fun analysisEndTime(analysisEndTime: Instant): FluentBuilder = apply { this.analysisEndTime = analysisEndTime }
        override fun analysisStartTime(analysisStartTime: Instant): FluentBuilder = apply { this.analysisStartTime = analysisStartTime }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun networkInsightsAnalysisIds(networkInsightsAnalysisIds: List<String>): FluentBuilder = apply { this.networkInsightsAnalysisIds = networkInsightsAnalysisIds }
        override fun networkInsightsPathId(networkInsightsPathId: String): FluentBuilder = apply { this.networkInsightsPathId = networkInsightsPathId }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
