// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeNetworkInterfaces.
 */
class DescribeNetworkInterfacesRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * addresses.private-ip-address - The private IPv4 addresses
     * associated with the network interface.
     * addresses.primary - Whether the private IPv4 address is the primary
     * IP address associated with the network interface.
     * addresses.association.public-ip - The association ID returned when
     * the network interface was associated with the Elastic IP address
     * (IPv4).
     * addresses.association.owner-id - The owner ID of the addresses associated with the network interface.
     * association.association-id - The association ID returned when the
     * network interface was associated with an IPv4 address.
     * association.allocation-id - The allocation ID returned when you
     * allocated the Elastic IP address (IPv4) for your network interface.
     * association.ip-owner-id - The owner of the Elastic IP address
     * (IPv4) associated with the network interface.
     * association.public-ip - The address of the Elastic IP address
     * (IPv4) bound to the network interface.
     * association.public-dns-name - The public DNS name for the network
     * interface (IPv4).
     * attachment.attachment-id - The ID of the interface attachment.
     * attachment.attach-time - The time that the network interface was attached to an instance.
     * attachment.delete-on-termination - Indicates whether the attachment is deleted when an instance is terminated.
     * attachment.device-index - The device index to which the network interface is attached.
     * attachment.instance-id - The ID of the instance to which the network interface is attached.
     * attachment.instance-owner-id - The owner ID of the instance to which the network interface is attached.
     * attachment.status - The status of the attachment (attaching | attached | detaching | detached).
     * availability-zone - The Availability Zone of the network interface.
     * description - The description of the network interface.
     * group-id - The ID of a security group associated with the network interface.
     * group-name - The name of a security group associated with the network interface.
     * ipv6-addresses.ipv6-address - An IPv6 address associated with
     * the network interface.
     * mac-address - The MAC address of the network interface.
     * network-interface-id - The ID of the network interface.
     * owner-id - The Amazon Web Services account ID of the network interface owner.
     * private-ip-address - The private IPv4 address or addresses of the
     * network interface.
     * private-dns-name - The private DNS name of the network interface (IPv4).
     * requester-id - The alias or Amazon Web Services account ID of the principal or service that created the network interface.
     * requester-managed - Indicates whether the network interface is being managed by an Amazon Web Service
     * (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
     * source-dest-check - Indicates whether the network interface performs source/destination checking.
     * A value of true means checking is enabled, and false means checking is disabled.
     * The value must be false for the network interface to perform network address translation (NAT) in your VPC.
     * status - The status of the network interface. If the network interface is not attached to an instance, the status is available;
     * if a network interface is attached to an instance the status is in-use.
     * subnet-id - The ID of the subnet for the network interface.
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * vpc-id - The ID of the VPC for the network interface.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of items to return for this request. The request returns a token that you
     * can specify in a subsequent call to get the next set of results. You cannot specify this
     * parameter and the network interface IDs parameter in the same request.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * One or more network interface IDs.
     * Default: Describes all your network interfaces.
     */
    val networkInterfaceIds: List<String>? = builder.networkInterfaceIds
    /**
     * The token to retrieve the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeNetworkInterfacesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeNetworkInterfacesRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("networkInterfaceIds=$networkInterfaceIds,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (networkInterfaceIds?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeNetworkInterfacesRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (networkInterfaceIds != other.networkInterfaceIds) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeNetworkInterfacesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeNetworkInterfacesRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * addresses.private-ip-address - The private IPv4 addresses
         * associated with the network interface.
         * addresses.primary - Whether the private IPv4 address is the primary
         * IP address associated with the network interface.
         * addresses.association.public-ip - The association ID returned when
         * the network interface was associated with the Elastic IP address
         * (IPv4).
         * addresses.association.owner-id - The owner ID of the addresses associated with the network interface.
         * association.association-id - The association ID returned when the
         * network interface was associated with an IPv4 address.
         * association.allocation-id - The allocation ID returned when you
         * allocated the Elastic IP address (IPv4) for your network interface.
         * association.ip-owner-id - The owner of the Elastic IP address
         * (IPv4) associated with the network interface.
         * association.public-ip - The address of the Elastic IP address
         * (IPv4) bound to the network interface.
         * association.public-dns-name - The public DNS name for the network
         * interface (IPv4).
         * attachment.attachment-id - The ID of the interface attachment.
         * attachment.attach-time - The time that the network interface was attached to an instance.
         * attachment.delete-on-termination - Indicates whether the attachment is deleted when an instance is terminated.
         * attachment.device-index - The device index to which the network interface is attached.
         * attachment.instance-id - The ID of the instance to which the network interface is attached.
         * attachment.instance-owner-id - The owner ID of the instance to which the network interface is attached.
         * attachment.status - The status of the attachment (attaching | attached | detaching | detached).
         * availability-zone - The Availability Zone of the network interface.
         * description - The description of the network interface.
         * group-id - The ID of a security group associated with the network interface.
         * group-name - The name of a security group associated with the network interface.
         * ipv6-addresses.ipv6-address - An IPv6 address associated with
         * the network interface.
         * mac-address - The MAC address of the network interface.
         * network-interface-id - The ID of the network interface.
         * owner-id - The Amazon Web Services account ID of the network interface owner.
         * private-ip-address - The private IPv4 address or addresses of the
         * network interface.
         * private-dns-name - The private DNS name of the network interface (IPv4).
         * requester-id - The alias or Amazon Web Services account ID of the principal or service that created the network interface.
         * requester-managed - Indicates whether the network interface is being managed by an Amazon Web Service
         * (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
         * source-dest-check - Indicates whether the network interface performs source/destination checking.
         * A value of true means checking is enabled, and false means checking is disabled.
         * The value must be false for the network interface to perform network address translation (NAT) in your VPC.
         * status - The status of the network interface. If the network interface is not attached to an instance, the status is available;
         * if a network interface is attached to an instance the status is in-use.
         * subnet-id - The ID of the subnet for the network interface.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * vpc-id - The ID of the VPC for the network interface.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of items to return for this request. The request returns a token that you
         * can specify in a subsequent call to get the next set of results. You cannot specify this
         * parameter and the network interface IDs parameter in the same request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * One or more network interface IDs.
         * Default: Describes all your network interfaces.
         */
        fun networkInterfaceIds(networkInterfaceIds: List<String>): FluentBuilder
        /**
         * The token to retrieve the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * addresses.private-ip-address - The private IPv4 addresses
         * associated with the network interface.
         * addresses.primary - Whether the private IPv4 address is the primary
         * IP address associated with the network interface.
         * addresses.association.public-ip - The association ID returned when
         * the network interface was associated with the Elastic IP address
         * (IPv4).
         * addresses.association.owner-id - The owner ID of the addresses associated with the network interface.
         * association.association-id - The association ID returned when the
         * network interface was associated with an IPv4 address.
         * association.allocation-id - The allocation ID returned when you
         * allocated the Elastic IP address (IPv4) for your network interface.
         * association.ip-owner-id - The owner of the Elastic IP address
         * (IPv4) associated with the network interface.
         * association.public-ip - The address of the Elastic IP address
         * (IPv4) bound to the network interface.
         * association.public-dns-name - The public DNS name for the network
         * interface (IPv4).
         * attachment.attachment-id - The ID of the interface attachment.
         * attachment.attach-time - The time that the network interface was attached to an instance.
         * attachment.delete-on-termination - Indicates whether the attachment is deleted when an instance is terminated.
         * attachment.device-index - The device index to which the network interface is attached.
         * attachment.instance-id - The ID of the instance to which the network interface is attached.
         * attachment.instance-owner-id - The owner ID of the instance to which the network interface is attached.
         * attachment.status - The status of the attachment (attaching | attached | detaching | detached).
         * availability-zone - The Availability Zone of the network interface.
         * description - The description of the network interface.
         * group-id - The ID of a security group associated with the network interface.
         * group-name - The name of a security group associated with the network interface.
         * ipv6-addresses.ipv6-address - An IPv6 address associated with
         * the network interface.
         * mac-address - The MAC address of the network interface.
         * network-interface-id - The ID of the network interface.
         * owner-id - The Amazon Web Services account ID of the network interface owner.
         * private-ip-address - The private IPv4 address or addresses of the
         * network interface.
         * private-dns-name - The private DNS name of the network interface (IPv4).
         * requester-id - The alias or Amazon Web Services account ID of the principal or service that created the network interface.
         * requester-managed - Indicates whether the network interface is being managed by an Amazon Web Service
         * (for example, Amazon Web Services Management Console, Auto Scaling, and so on).
         * source-dest-check - Indicates whether the network interface performs source/destination checking.
         * A value of true means checking is enabled, and false means checking is disabled.
         * The value must be false for the network interface to perform network address translation (NAT) in your VPC.
         * status - The status of the network interface. If the network interface is not attached to an instance, the status is available;
         * if a network interface is attached to an instance the status is in-use.
         * subnet-id - The ID of the subnet for the network interface.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * vpc-id - The ID of the VPC for the network interface.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of items to return for this request. The request returns a token that you
         * can specify in a subsequent call to get the next set of results. You cannot specify this
         * parameter and the network interface IDs parameter in the same request.
         */
        var maxResults: Int?
        /**
         * One or more network interface IDs.
         * Default: Describes all your network interfaces.
         */
        var networkInterfaceIds: List<String>?
        /**
         * The token to retrieve the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeNetworkInterfacesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var networkInterfaceIds: List<String>? = null
        override var nextToken: String? = null

        constructor(x: DescribeNetworkInterfacesRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.networkInterfaceIds = x.networkInterfaceIds
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeNetworkInterfacesRequest = DescribeNetworkInterfacesRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun networkInterfaceIds(networkInterfaceIds: List<String>): FluentBuilder = apply { this.networkInterfaceIds = networkInterfaceIds }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
