// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeRouteTablesRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * association.route-table-association-id - The ID of an association
     * ID for the route table.
     * association.route-table-id - The ID of the route table involved in
     * the association.
     * association.subnet-id - The ID of the subnet involved in the
     * association.
     * association.main - Indicates whether the route table is the main
     * route table for the VPC (true | false). Route tables
     * that do not have an association ID are not returned in the response.
     * owner-id - The ID of the Amazon Web Services account that owns the route table.
     * route-table-id - The ID of the route table.
     * route.destination-cidr-block - The IPv4 CIDR range specified in a
     * route in the table.
     * route.destination-ipv6-cidr-block - The IPv6 CIDR range specified in a route in the route table.
     * route.destination-prefix-list-id - The ID (prefix) of the Amazon Web Service
     * specified in a route in the table.
     * route.egress-only-internet-gateway-id - The ID of an
     * egress-only Internet gateway specified in a route in the route table.
     * route.gateway-id - The ID of a gateway specified in a route in the table.
     * route.instance-id - The ID of an instance specified in a route in the table.
     * route.nat-gateway-id - The ID of a NAT gateway.
     * route.transit-gateway-id - The ID of a transit gateway.
     * route.origin - Describes how the route was created.
     * CreateRouteTable indicates that the route was automatically
     * created when the route table was created; CreateRoute indicates
     * that the route was manually added to the route table;
     * EnableVgwRoutePropagation indicates that the route was
     * propagated by route propagation.
     * route.state - The state of a route in the route table
     * (active | blackhole). The blackhole state
     * indicates that the route's target isn't available (for example, the specified
     * gateway isn't attached to the VPC, the specified NAT instance has been
     * terminated, and so on).
     * route.vpc-peering-connection-id - The ID of a VPC peering
     * connection specified in a route in the table.
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * vpc-id - The ID of the VPC for the route table.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call.
     * To retrieve the remaining results, make another call with the returned nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * One or more route table IDs.
     * Default: Describes all your route tables.
     */
    val routeTableIds: List<String>? = builder.routeTableIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeRouteTablesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRouteTablesRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("routeTableIds=$routeTableIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeRouteTablesRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (routeTableIds != other.routeTableIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeRouteTablesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeRouteTablesRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * association.route-table-association-id - The ID of an association
         * ID for the route table.
         * association.route-table-id - The ID of the route table involved in
         * the association.
         * association.subnet-id - The ID of the subnet involved in the
         * association.
         * association.main - Indicates whether the route table is the main
         * route table for the VPC (true | false). Route tables
         * that do not have an association ID are not returned in the response.
         * owner-id - The ID of the Amazon Web Services account that owns the route table.
         * route-table-id - The ID of the route table.
         * route.destination-cidr-block - The IPv4 CIDR range specified in a
         * route in the table.
         * route.destination-ipv6-cidr-block - The IPv6 CIDR range specified in a route in the route table.
         * route.destination-prefix-list-id - The ID (prefix) of the Amazon Web Service
         * specified in a route in the table.
         * route.egress-only-internet-gateway-id - The ID of an
         * egress-only Internet gateway specified in a route in the route table.
         * route.gateway-id - The ID of a gateway specified in a route in the table.
         * route.instance-id - The ID of an instance specified in a route in the table.
         * route.nat-gateway-id - The ID of a NAT gateway.
         * route.transit-gateway-id - The ID of a transit gateway.
         * route.origin - Describes how the route was created.
         * CreateRouteTable indicates that the route was automatically
         * created when the route table was created; CreateRoute indicates
         * that the route was manually added to the route table;
         * EnableVgwRoutePropagation indicates that the route was
         * propagated by route propagation.
         * route.state - The state of a route in the route table
         * (active | blackhole). The blackhole state
         * indicates that the route's target isn't available (for example, the specified
         * gateway isn't attached to the VPC, the specified NAT instance has been
         * terminated, and so on).
         * route.vpc-peering-connection-id - The ID of a VPC peering
         * connection specified in a route in the table.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * vpc-id - The ID of the VPC for the route table.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * One or more route table IDs.
         * Default: Describes all your route tables.
         */
        fun routeTableIds(routeTableIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * association.route-table-association-id - The ID of an association
         * ID for the route table.
         * association.route-table-id - The ID of the route table involved in
         * the association.
         * association.subnet-id - The ID of the subnet involved in the
         * association.
         * association.main - Indicates whether the route table is the main
         * route table for the VPC (true | false). Route tables
         * that do not have an association ID are not returned in the response.
         * owner-id - The ID of the Amazon Web Services account that owns the route table.
         * route-table-id - The ID of the route table.
         * route.destination-cidr-block - The IPv4 CIDR range specified in a
         * route in the table.
         * route.destination-ipv6-cidr-block - The IPv6 CIDR range specified in a route in the route table.
         * route.destination-prefix-list-id - The ID (prefix) of the Amazon Web Service
         * specified in a route in the table.
         * route.egress-only-internet-gateway-id - The ID of an
         * egress-only Internet gateway specified in a route in the route table.
         * route.gateway-id - The ID of a gateway specified in a route in the table.
         * route.instance-id - The ID of an instance specified in a route in the table.
         * route.nat-gateway-id - The ID of a NAT gateway.
         * route.transit-gateway-id - The ID of a transit gateway.
         * route.origin - Describes how the route was created.
         * CreateRouteTable indicates that the route was automatically
         * created when the route table was created; CreateRoute indicates
         * that the route was manually added to the route table;
         * EnableVgwRoutePropagation indicates that the route was
         * propagated by route propagation.
         * route.state - The state of a route in the route table
         * (active | blackhole). The blackhole state
         * indicates that the route's target isn't available (for example, the specified
         * gateway isn't attached to the VPC, the specified NAT instance has been
         * terminated, and so on).
         * route.vpc-peering-connection-id - The ID of a VPC peering
         * connection specified in a route in the table.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * vpc-id - The ID of the VPC for the route table.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next page of results.
         */
        var nextToken: String?
        /**
         * One or more route table IDs.
         * Default: Describes all your route tables.
         */
        var routeTableIds: List<String>?

        fun build(): DescribeRouteTablesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var routeTableIds: List<String>? = null

        constructor(x: DescribeRouteTablesRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.routeTableIds = x.routeTableIds
        }

        override fun build(): DescribeRouteTablesRequest = DescribeRouteTablesRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun routeTableIds(routeTableIds: List<String>): FluentBuilder = apply { this.routeTableIds = routeTableIds }
    }
}
