// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeScheduledInstanceAvailability.
 */
class DescribeScheduledInstanceAvailabilityRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The filters.
     * availability-zone - The Availability Zone (for example, us-west-2a).
     * instance-type - The instance type (for example, c4.large).
     * network-platform - The network platform (EC2-Classic or EC2-VPC).
     * platform - The platform (Linux/UNIX or Windows).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The time period for the first schedule to start.
     */
    val firstSlotStartTimeRange: SlotDateTimeRangeRequest? = builder.firstSlotStartTimeRange
    /**
     * The maximum number of results to return in a single call.
     * This value can be between 5 and 300. The default value is 300.
     * To retrieve the remaining results, make another call with the returned
     * NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The maximum available duration, in hours. This value must be greater than MinSlotDurationInHours
     * and less than 1,720.
     */
    val maxSlotDurationInHours: Int? = builder.maxSlotDurationInHours
    /**
     * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.
     */
    val minSlotDurationInHours: Int? = builder.minSlotDurationInHours
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The schedule recurrence.
     */
    val recurrence: ScheduledInstanceRecurrenceRequest? = builder.recurrence

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeScheduledInstanceAvailabilityRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScheduledInstanceAvailabilityRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("firstSlotStartTimeRange=$firstSlotStartTimeRange,")
        append("maxResults=$maxResults,")
        append("maxSlotDurationInHours=$maxSlotDurationInHours,")
        append("minSlotDurationInHours=$minSlotDurationInHours,")
        append("nextToken=$nextToken,")
        append("recurrence=$recurrence)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (firstSlotStartTimeRange?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (maxSlotDurationInHours ?: 0)
        result = 31 * result + (minSlotDurationInHours ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeScheduledInstanceAvailabilityRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (firstSlotStartTimeRange != other.firstSlotStartTimeRange) return false
        if (maxResults != other.maxResults) return false
        if (maxSlotDurationInHours != other.maxSlotDurationInHours) return false
        if (minSlotDurationInHours != other.minSlotDurationInHours) return false
        if (nextToken != other.nextToken) return false
        if (recurrence != other.recurrence) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeScheduledInstanceAvailabilityRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeScheduledInstanceAvailabilityRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The filters.
         * availability-zone - The Availability Zone (for example, us-west-2a).
         * instance-type - The instance type (for example, c4.large).
         * network-platform - The network platform (EC2-Classic or EC2-VPC).
         * platform - The platform (Linux/UNIX or Windows).
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The time period for the first schedule to start.
         */
        fun firstSlotStartTimeRange(firstSlotStartTimeRange: SlotDateTimeRangeRequest): FluentBuilder
        /**
         * The maximum number of results to return in a single call.
         * This value can be between 5 and 300. The default value is 300.
         * To retrieve the remaining results, make another call with the returned
         * NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The maximum available duration, in hours. This value must be greater than MinSlotDurationInHours
         * and less than 1,720.
         */
        fun maxSlotDurationInHours(maxSlotDurationInHours: Int): FluentBuilder
        /**
         * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.
         */
        fun minSlotDurationInHours(minSlotDurationInHours: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The schedule recurrence.
         */
        fun recurrence(recurrence: ScheduledInstanceRecurrenceRequest): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The filters.
         * availability-zone - The Availability Zone (for example, us-west-2a).
         * instance-type - The instance type (for example, c4.large).
         * network-platform - The network platform (EC2-Classic or EC2-VPC).
         * platform - The platform (Linux/UNIX or Windows).
         */
        var filters: List<Filter>?
        /**
         * The time period for the first schedule to start.
         */
        var firstSlotStartTimeRange: SlotDateTimeRangeRequest?
        /**
         * The maximum number of results to return in a single call.
         * This value can be between 5 and 300. The default value is 300.
         * To retrieve the remaining results, make another call with the returned
         * NextToken value.
         */
        var maxResults: Int?
        /**
         * The maximum available duration, in hours. This value must be greater than MinSlotDurationInHours
         * and less than 1,720.
         */
        var maxSlotDurationInHours: Int?
        /**
         * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.
         */
        var minSlotDurationInHours: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * The schedule recurrence.
         */
        var recurrence: ScheduledInstanceRecurrenceRequest?

        fun build(): DescribeScheduledInstanceAvailabilityRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SlotDateTimeRangeRequest] inside the given [block]
         */
        fun firstSlotStartTimeRange(block: SlotDateTimeRangeRequest.DslBuilder.() -> kotlin.Unit) {
            this.firstSlotStartTimeRange = SlotDateTimeRangeRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ScheduledInstanceRecurrenceRequest] inside the given [block]
         */
        fun recurrence(block: ScheduledInstanceRecurrenceRequest.DslBuilder.() -> kotlin.Unit) {
            this.recurrence = ScheduledInstanceRecurrenceRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var firstSlotStartTimeRange: SlotDateTimeRangeRequest? = null
        override var maxResults: Int? = null
        override var maxSlotDurationInHours: Int? = null
        override var minSlotDurationInHours: Int? = null
        override var nextToken: String? = null
        override var recurrence: ScheduledInstanceRecurrenceRequest? = null

        constructor(x: DescribeScheduledInstanceAvailabilityRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.firstSlotStartTimeRange = x.firstSlotStartTimeRange
            this.maxResults = x.maxResults
            this.maxSlotDurationInHours = x.maxSlotDurationInHours
            this.minSlotDurationInHours = x.minSlotDurationInHours
            this.nextToken = x.nextToken
            this.recurrence = x.recurrence
        }

        override fun build(): DescribeScheduledInstanceAvailabilityRequest = DescribeScheduledInstanceAvailabilityRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun firstSlotStartTimeRange(firstSlotStartTimeRange: SlotDateTimeRangeRequest): FluentBuilder = apply { this.firstSlotStartTimeRange = firstSlotStartTimeRange }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun maxSlotDurationInHours(maxSlotDurationInHours: Int): FluentBuilder = apply { this.maxSlotDurationInHours = maxSlotDurationInHours }
        override fun minSlotDurationInHours(minSlotDurationInHours: Int): FluentBuilder = apply { this.minSlotDurationInHours = minSlotDurationInHours }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun recurrence(recurrence: ScheduledInstanceRecurrenceRequest): FluentBuilder = apply { this.recurrence = recurrence }
    }
}
