// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeScheduledInstances.
 */
class DescribeScheduledInstancesRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The filters.
     * availability-zone - The Availability Zone (for example, us-west-2a).
     * instance-type - The instance type (for example, c4.large).
     * network-platform - The network platform (EC2-Classic or EC2-VPC).
     * platform - The platform (Linux/UNIX or Windows).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return in a single call.
     * This value can be between 5 and 300. The default value is 100.
     * To retrieve the remaining results, make another call with the returned
     * NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The Scheduled Instance IDs.
     */
    val scheduledInstanceIds: List<String>? = builder.scheduledInstanceIds
    /**
     * The time period for the first schedule to start.
     */
    val slotStartTimeRange: SlotStartTimeRangeRequest? = builder.slotStartTimeRange

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeScheduledInstancesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScheduledInstancesRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("scheduledInstanceIds=$scheduledInstanceIds,")
        append("slotStartTimeRange=$slotStartTimeRange)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scheduledInstanceIds?.hashCode() ?: 0)
        result = 31 * result + (slotStartTimeRange?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeScheduledInstancesRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (scheduledInstanceIds != other.scheduledInstanceIds) return false
        if (slotStartTimeRange != other.slotStartTimeRange) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeScheduledInstancesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeScheduledInstancesRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The filters.
         * availability-zone - The Availability Zone (for example, us-west-2a).
         * instance-type - The instance type (for example, c4.large).
         * network-platform - The network platform (EC2-Classic or EC2-VPC).
         * platform - The platform (Linux/UNIX or Windows).
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return in a single call.
         * This value can be between 5 and 300. The default value is 100.
         * To retrieve the remaining results, make another call with the returned
         * NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The Scheduled Instance IDs.
         */
        fun scheduledInstanceIds(scheduledInstanceIds: List<String>): FluentBuilder
        /**
         * The time period for the first schedule to start.
         */
        fun slotStartTimeRange(slotStartTimeRange: SlotStartTimeRangeRequest): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The filters.
         * availability-zone - The Availability Zone (for example, us-west-2a).
         * instance-type - The instance type (for example, c4.large).
         * network-platform - The network platform (EC2-Classic or EC2-VPC).
         * platform - The platform (Linux/UNIX or Windows).
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return in a single call.
         * This value can be between 5 and 300. The default value is 100.
         * To retrieve the remaining results, make another call with the returned
         * NextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * The Scheduled Instance IDs.
         */
        var scheduledInstanceIds: List<String>?
        /**
         * The time period for the first schedule to start.
         */
        var slotStartTimeRange: SlotStartTimeRangeRequest?

        fun build(): DescribeScheduledInstancesRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SlotStartTimeRangeRequest] inside the given [block]
         */
        fun slotStartTimeRange(block: SlotStartTimeRangeRequest.DslBuilder.() -> kotlin.Unit) {
            this.slotStartTimeRange = SlotStartTimeRangeRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var scheduledInstanceIds: List<String>? = null
        override var slotStartTimeRange: SlotStartTimeRangeRequest? = null

        constructor(x: DescribeScheduledInstancesRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.scheduledInstanceIds = x.scheduledInstanceIds
            this.slotStartTimeRange = x.slotStartTimeRange
        }

        override fun build(): DescribeScheduledInstancesRequest = DescribeScheduledInstancesRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun scheduledInstanceIds(scheduledInstanceIds: List<String>): FluentBuilder = apply { this.scheduledInstanceIds = scheduledInstanceIds }
        override fun slotStartTimeRange(slotStartTimeRange: SlotStartTimeRangeRequest): FluentBuilder = apply { this.slotStartTimeRange = slotStartTimeRange }
    }
}
