// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeSpotFleetInstances.
 */
class DescribeSpotFleetInstancesRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The maximum number of results to return in a single call. Specify a value between 1
     * and 1000. The default value is 1000. To retrieve the remaining results, make another
     * call with the returned NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The ID of the Spot Fleet request.
     */
    val spotFleetRequestId: String? = builder.spotFleetRequestId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSpotFleetInstancesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSpotFleetInstancesRequest(")
        append("dryRun=$dryRun,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("spotFleetRequestId=$spotFleetRequestId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSpotFleetInstancesRequest

        if (dryRun != other.dryRun) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (spotFleetRequestId != other.spotFleetRequestId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSpotFleetInstancesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSpotFleetInstancesRequest
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The maximum number of results to return in a single call. Specify a value between 1
         * and 1000. The default value is 1000. To retrieve the remaining results, make another
         * call with the returned NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The ID of the Spot Fleet request.
         */
        fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The maximum number of results to return in a single call. Specify a value between 1
         * and 1000. The default value is 1000. To retrieve the remaining results, make another
         * call with the returned NextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * The ID of the Spot Fleet request.
         */
        var spotFleetRequestId: String?

        fun build(): DescribeSpotFleetInstancesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var spotFleetRequestId: String? = null

        constructor(x: DescribeSpotFleetInstancesRequest) : this() {
            this.dryRun = x.dryRun
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.spotFleetRequestId = x.spotFleetRequestId
        }

        override fun build(): DescribeSpotFleetInstancesRequest = DescribeSpotFleetInstancesRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder = apply { this.spotFleetRequestId = spotFleetRequestId }
    }
}
