// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the parameters for DescribeSpotFleetRequestHistory.
 */
class DescribeSpotFleetRequestHistoryRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The type of events to describe. By default, all events are described.
     */
    val eventType: EventType? = builder.eventType
    /**
     * The maximum number of results to return in a single call. Specify a value between 1
     * and 1000. The default value is 1000. To retrieve the remaining results, make another
     * call with the returned NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The ID of the Spot Fleet request.
     */
    val spotFleetRequestId: String? = builder.spotFleetRequestId
    /**
     * The starting date and time for the events, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSpotFleetRequestHistoryRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSpotFleetRequestHistoryRequest(")
        append("dryRun=$dryRun,")
        append("eventType=$eventType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("spotFleetRequestId=$spotFleetRequestId,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSpotFleetRequestHistoryRequest

        if (dryRun != other.dryRun) return false
        if (eventType != other.eventType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (spotFleetRequestId != other.spotFleetRequestId) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSpotFleetRequestHistoryRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSpotFleetRequestHistoryRequest
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The type of events to describe. By default, all events are described.
         */
        fun eventType(eventType: EventType): FluentBuilder
        /**
         * The maximum number of results to return in a single call. Specify a value between 1
         * and 1000. The default value is 1000. To retrieve the remaining results, make another
         * call with the returned NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The ID of the Spot Fleet request.
         */
        fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder
        /**
         * The starting date and time for the events, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The type of events to describe. By default, all events are described.
         */
        var eventType: EventType?
        /**
         * The maximum number of results to return in a single call. Specify a value between 1
         * and 1000. The default value is 1000. To retrieve the remaining results, make another
         * call with the returned NextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * The ID of the Spot Fleet request.
         */
        var spotFleetRequestId: String?
        /**
         * The starting date and time for the events, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        var startTime: Instant?

        fun build(): DescribeSpotFleetRequestHistoryRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var eventType: EventType? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var spotFleetRequestId: String? = null
        override var startTime: Instant? = null

        constructor(x: DescribeSpotFleetRequestHistoryRequest) : this() {
            this.dryRun = x.dryRun
            this.eventType = x.eventType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.spotFleetRequestId = x.spotFleetRequestId
            this.startTime = x.startTime
        }

        override fun build(): DescribeSpotFleetRequestHistoryRequest = DescribeSpotFleetRequestHistoryRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun eventType(eventType: EventType): FluentBuilder = apply { this.eventType = eventType }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder = apply { this.spotFleetRequestId = spotFleetRequestId }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
