// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the output of DescribeSpotFleetRequestHistory.
 */
class DescribeSpotFleetRequestHistoryResponse private constructor(builder: BuilderImpl) {
    /**
     * Information about the events in the history of the Spot Fleet request.
     */
    val historyRecords: List<HistoryRecord>? = builder.historyRecords
    /**
     * The last date and time for the events, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     * All records up to this time were retrieved.
     * If nextToken indicates that there are more results, this value is not
     * present.
     */
    val lastEvaluatedTime: Instant? = builder.lastEvaluatedTime
    /**
     * The token required to retrieve the next set of results. This value is
     * null when there are no more results to return.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The ID of the Spot Fleet request.
     */
    val spotFleetRequestId: String? = builder.spotFleetRequestId
    /**
     * The starting date and time for the events, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSpotFleetRequestHistoryResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSpotFleetRequestHistoryResponse(")
        append("historyRecords=$historyRecords,")
        append("lastEvaluatedTime=$lastEvaluatedTime,")
        append("nextToken=$nextToken,")
        append("spotFleetRequestId=$spotFleetRequestId,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = historyRecords?.hashCode() ?: 0
        result = 31 * result + (lastEvaluatedTime?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (spotFleetRequestId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSpotFleetRequestHistoryResponse

        if (historyRecords != other.historyRecords) return false
        if (lastEvaluatedTime != other.lastEvaluatedTime) return false
        if (nextToken != other.nextToken) return false
        if (spotFleetRequestId != other.spotFleetRequestId) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSpotFleetRequestHistoryResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSpotFleetRequestHistoryResponse
        /**
         * Information about the events in the history of the Spot Fleet request.
         */
        fun historyRecords(historyRecords: List<HistoryRecord>): FluentBuilder
        /**
         * The last date and time for the events, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * All records up to this time were retrieved.
         * If nextToken indicates that there are more results, this value is not
         * present.
         */
        fun lastEvaluatedTime(lastEvaluatedTime: Instant): FluentBuilder
        /**
         * The token required to retrieve the next set of results. This value is
         * null when there are no more results to return.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The ID of the Spot Fleet request.
         */
        fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder
        /**
         * The starting date and time for the events, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the events in the history of the Spot Fleet request.
         */
        var historyRecords: List<HistoryRecord>?
        /**
         * The last date and time for the events, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * All records up to this time were retrieved.
         * If nextToken indicates that there are more results, this value is not
         * present.
         */
        var lastEvaluatedTime: Instant?
        /**
         * The token required to retrieve the next set of results. This value is
         * null when there are no more results to return.
         */
        var nextToken: String?
        /**
         * The ID of the Spot Fleet request.
         */
        var spotFleetRequestId: String?
        /**
         * The starting date and time for the events, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        var startTime: Instant?

        fun build(): DescribeSpotFleetRequestHistoryResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var historyRecords: List<HistoryRecord>? = null
        override var lastEvaluatedTime: Instant? = null
        override var nextToken: String? = null
        override var spotFleetRequestId: String? = null
        override var startTime: Instant? = null

        constructor(x: DescribeSpotFleetRequestHistoryResponse) : this() {
            this.historyRecords = x.historyRecords
            this.lastEvaluatedTime = x.lastEvaluatedTime
            this.nextToken = x.nextToken
            this.spotFleetRequestId = x.spotFleetRequestId
            this.startTime = x.startTime
        }

        override fun build(): DescribeSpotFleetRequestHistoryResponse = DescribeSpotFleetRequestHistoryResponse(this)
        override fun historyRecords(historyRecords: List<HistoryRecord>): FluentBuilder = apply { this.historyRecords = historyRecords }
        override fun lastEvaluatedTime(lastEvaluatedTime: Instant): FluentBuilder = apply { this.lastEvaluatedTime = lastEvaluatedTime }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun spotFleetRequestId(spotFleetRequestId: String): FluentBuilder = apply { this.spotFleetRequestId = spotFleetRequestId }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
