// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the parameters for DescribeSpotPriceHistory.
 */
class DescribeSpotPriceHistoryRequest private constructor(builder: BuilderImpl) {
    /**
     * Filters the results by the specified Availability Zone.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The date and time, up to the current date, from which to stop retrieving the price
     * history data, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     */
    val endTime: Instant? = builder.endTime
    /**
     * One or more filters.
     * availability-zone - The Availability Zone for which prices should
     * be returned.
     * instance-type - The type of instance (for example,
     * m3.medium).
     * product-description - The product description for the Spot price
     * (Linux/UNIX | Red Hat Enterprise Linux |
     * SUSE Linux | Windows | Linux/UNIX (Amazon
     * VPC) | Red Hat Enterprise Linux (Amazon VPC) |
     * SUSE Linux (Amazon VPC) | Windows (Amazon
     * VPC)).
     * spot-price - The Spot price. The value must match exactly (or use
     * wildcards; greater than or less than comparison is not supported).
     * timestamp - The time stamp of the Spot price history, in UTC format
     * (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     * You can use wildcards (* and ?). Greater than or less than comparison is not
     * supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * Filters the results by the specified instance types.
     */
    val instanceTypes: List<InstanceType>? = builder.instanceTypes
    /**
     * The maximum number of results to return in a single call. Specify a value between 1
     * and 1000. The default value is 1000. To retrieve the remaining results, make another
     * call with the returned NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * Filters the results by the specified basic product descriptions.
     */
    val productDescriptions: List<String>? = builder.productDescriptions
    /**
     * The date and time, up to the past 90 days, from which to start retrieving the price
     * history data, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeSpotPriceHistoryRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSpotPriceHistoryRequest(")
        append("availabilityZone=$availabilityZone,")
        append("dryRun=$dryRun,")
        append("endTime=$endTime,")
        append("filters=$filters,")
        append("instanceTypes=$instanceTypes,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("productDescriptions=$productDescriptions,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (productDescriptions?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeSpotPriceHistoryRequest

        if (availabilityZone != other.availabilityZone) return false
        if (dryRun != other.dryRun) return false
        if (endTime != other.endTime) return false
        if (filters != other.filters) return false
        if (instanceTypes != other.instanceTypes) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (productDescriptions != other.productDescriptions) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeSpotPriceHistoryRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeSpotPriceHistoryRequest
        /**
         * Filters the results by the specified Availability Zone.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The date and time, up to the current date, from which to stop retrieving the price
         * history data, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * One or more filters.
         * availability-zone - The Availability Zone for which prices should
         * be returned.
         * instance-type - The type of instance (for example,
         * m3.medium).
         * product-description - The product description for the Spot price
         * (Linux/UNIX | Red Hat Enterprise Linux |
         * SUSE Linux | Windows | Linux/UNIX (Amazon
         * VPC) | Red Hat Enterprise Linux (Amazon VPC) |
         * SUSE Linux (Amazon VPC) | Windows (Amazon
         * VPC)).
         * spot-price - The Spot price. The value must match exactly (or use
         * wildcards; greater than or less than comparison is not supported).
         * timestamp - The time stamp of the Spot price history, in UTC format
         * (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * You can use wildcards (* and ?). Greater than or less than comparison is not
         * supported.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * Filters the results by the specified instance types.
         */
        fun instanceTypes(instanceTypes: List<InstanceType>): FluentBuilder
        /**
         * The maximum number of results to return in a single call. Specify a value between 1
         * and 1000. The default value is 1000. To retrieve the remaining results, make another
         * call with the returned NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * Filters the results by the specified basic product descriptions.
         */
        fun productDescriptions(productDescriptions: List<String>): FluentBuilder
        /**
         * The date and time, up to the past 90 days, from which to start retrieving the price
         * history data, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Filters the results by the specified Availability Zone.
         */
        var availabilityZone: String?
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The date and time, up to the current date, from which to stop retrieving the price
         * history data, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        var endTime: Instant?
        /**
         * One or more filters.
         * availability-zone - The Availability Zone for which prices should
         * be returned.
         * instance-type - The type of instance (for example,
         * m3.medium).
         * product-description - The product description for the Spot price
         * (Linux/UNIX | Red Hat Enterprise Linux |
         * SUSE Linux | Windows | Linux/UNIX (Amazon
         * VPC) | Red Hat Enterprise Linux (Amazon VPC) |
         * SUSE Linux (Amazon VPC) | Windows (Amazon
         * VPC)).
         * spot-price - The Spot price. The value must match exactly (or use
         * wildcards; greater than or less than comparison is not supported).
         * timestamp - The time stamp of the Spot price history, in UTC format
         * (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * You can use wildcards (* and ?). Greater than or less than comparison is not
         * supported.
         */
        var filters: List<Filter>?
        /**
         * Filters the results by the specified instance types.
         */
        var instanceTypes: List<InstanceType>?
        /**
         * The maximum number of results to return in a single call. Specify a value between 1
         * and 1000. The default value is 1000. To retrieve the remaining results, make another
         * call with the returned NextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * Filters the results by the specified basic product descriptions.
         */
        var productDescriptions: List<String>?
        /**
         * The date and time, up to the past 90 days, from which to start retrieving the price
         * history data, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        var startTime: Instant?

        fun build(): DescribeSpotPriceHistoryRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var dryRun: Boolean? = null
        override var endTime: Instant? = null
        override var filters: List<Filter>? = null
        override var instanceTypes: List<InstanceType>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var productDescriptions: List<String>? = null
        override var startTime: Instant? = null

        constructor(x: DescribeSpotPriceHistoryRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.dryRun = x.dryRun
            this.endTime = x.endTime
            this.filters = x.filters
            this.instanceTypes = x.instanceTypes
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.productDescriptions = x.productDescriptions
            this.startTime = x.startTime
        }

        override fun build(): DescribeSpotPriceHistoryRequest = DescribeSpotPriceHistoryRequest(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun instanceTypes(instanceTypes: List<InstanceType>): FluentBuilder = apply { this.instanceTypes = instanceTypes }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun productDescriptions(productDescriptions: List<String>): FluentBuilder = apply { this.productDescriptions = productDescriptions }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
