// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeStaleSecurityGroupsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of items to return. (You received this token from a prior call.)
     */
    val nextToken: String? = builder.nextToken
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeStaleSecurityGroupsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStaleSecurityGroupsRequest(")
        append("dryRun=$dryRun,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeStaleSecurityGroupsRequest

        if (dryRun != other.dryRun) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeStaleSecurityGroupsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeStaleSecurityGroupsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of items to return. (You received this token from a prior call.)
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
         */
        var maxResults: Int?
        /**
         * The token for the next set of items to return. (You received this token from a prior call.)
         */
        var nextToken: String?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): DescribeStaleSecurityGroupsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var vpcId: String? = null

        constructor(x: DescribeStaleSecurityGroupsRequest) : this() {
            this.dryRun = x.dryRun
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.vpcId = x.vpcId
        }

        override fun build(): DescribeStaleSecurityGroupsRequest = DescribeStaleSecurityGroupsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
