// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeTransitGatewaysRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters. The possible values are:
     * options.propagation-default-route-table-id - The ID of the default propagation route table.
     * options.amazon-side-asn - The private ASN for the Amazon side of a BGP session.
     * options.association-default-route-table-id - The ID of the default association route table.
     * options.auto-accept-shared-attachments - Indicates whether there is automatic acceptance of attachment requests (enable | disable).
     * options.default-route-table-association - Indicates whether resource attachments are automatically
     * associated with the default association route table (enable | disable).
     * options.default-route-table-propagation - Indicates whether resource attachments automatically propagate
     * routes to the default propagation route table (enable | disable).
     * options.dns-support - Indicates whether DNS support is enabled (enable | disable).
     * options.vpn-ecmp-support - Indicates whether Equal Cost Multipath Protocol support is enabled  (enable | disable).
     * owner-id - The ID of the Amazon Web Services account that owns the transit gateway.
     * state - The state of the transit gateway (available | deleted | deleting | modifying | pending).
     * transit-gateway-id - The ID of the transit gateway.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call.
     * To retrieve the remaining results, make another call with the returned nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The IDs of the transit gateways.
     */
    val transitGatewayIds: List<String>? = builder.transitGatewayIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeTransitGatewaysRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTransitGatewaysRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("transitGatewayIds=$transitGatewayIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeTransitGatewaysRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (transitGatewayIds != other.transitGatewayIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeTransitGatewaysRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeTransitGatewaysRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters. The possible values are:
         * options.propagation-default-route-table-id - The ID of the default propagation route table.
         * options.amazon-side-asn - The private ASN for the Amazon side of a BGP session.
         * options.association-default-route-table-id - The ID of the default association route table.
         * options.auto-accept-shared-attachments - Indicates whether there is automatic acceptance of attachment requests (enable | disable).
         * options.default-route-table-association - Indicates whether resource attachments are automatically
         * associated with the default association route table (enable | disable).
         * options.default-route-table-propagation - Indicates whether resource attachments automatically propagate
         * routes to the default propagation route table (enable | disable).
         * options.dns-support - Indicates whether DNS support is enabled (enable | disable).
         * options.vpn-ecmp-support - Indicates whether Equal Cost Multipath Protocol support is enabled  (enable | disable).
         * owner-id - The ID of the Amazon Web Services account that owns the transit gateway.
         * state - The state of the transit gateway (available | deleted | deleting | modifying | pending).
         * transit-gateway-id - The ID of the transit gateway.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The IDs of the transit gateways.
         */
        fun transitGatewayIds(transitGatewayIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters. The possible values are:
         * options.propagation-default-route-table-id - The ID of the default propagation route table.
         * options.amazon-side-asn - The private ASN for the Amazon side of a BGP session.
         * options.association-default-route-table-id - The ID of the default association route table.
         * options.auto-accept-shared-attachments - Indicates whether there is automatic acceptance of attachment requests (enable | disable).
         * options.default-route-table-association - Indicates whether resource attachments are automatically
         * associated with the default association route table (enable | disable).
         * options.default-route-table-propagation - Indicates whether resource attachments automatically propagate
         * routes to the default propagation route table (enable | disable).
         * options.dns-support - Indicates whether DNS support is enabled (enable | disable).
         * options.vpn-ecmp-support - Indicates whether Equal Cost Multipath Protocol support is enabled  (enable | disable).
         * owner-id - The ID of the Amazon Web Services account that owns the transit gateway.
         * state - The state of the transit gateway (available | deleted | deleting | modifying | pending).
         * transit-gateway-id - The ID of the transit gateway.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next page of results.
         */
        var nextToken: String?
        /**
         * The IDs of the transit gateways.
         */
        var transitGatewayIds: List<String>?

        fun build(): DescribeTransitGatewaysRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var transitGatewayIds: List<String>? = null

        constructor(x: DescribeTransitGatewaysRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.transitGatewayIds = x.transitGatewayIds
        }

        override fun build(): DescribeTransitGatewaysRequest = DescribeTransitGatewaysRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun transitGatewayIds(transitGatewayIds: List<String>): FluentBuilder = apply { this.transitGatewayIds = transitGatewayIds }
    }
}
