// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeVolumeStatusRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The filters.
     * action.code - The action code for the event (for example,
     * enable-volume-io).
     * action.description - A description of the action.
     * action.event-id - The event ID associated with the action.
     * availability-zone - The Availability Zone of the instance.
     * event.description - A description of the event.
     * event.event-id - The event ID.
     * event.event-type - The event type (for io-enabled:
     * passed | failed; for io-performance:
     * io-performance:degraded | io-performance:severely-degraded |
     * io-performance:stalled).
     * event.not-after - The latest end time for the event.
     * event.not-before - The earliest start time for the event.
     * volume-status.details-name - The cause for
     * volume-status.status (io-enabled |
     * io-performance).
     * volume-status.details-status - The status of
     * volume-status.details-name (for io-enabled:
     * passed | failed; for io-performance:
     * normal | degraded | severely-degraded |
     * stalled).
     * volume-status.status - The status of the volume (ok |
     * impaired | warning | insufficient-data).
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of volume results returned by DescribeVolumeStatus in
     * paginated output. When this parameter is used, the request only returns
     * MaxResults results in a single page along with a NextToken
     * response element. The remaining results of the initial request can be seen by sending another
     * request with the returned NextToken value. This value can be between 5 and 1,000;
     * if MaxResults is given a value larger than 1,000, only 1,000 results are returned.
     * If this parameter is not used, then DescribeVolumeStatus returns all results. You
     * cannot specify this parameter and the volume IDs parameter in the same request.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The NextToken value to include in a future DescribeVolumeStatus
     * request. When the results of the request exceed MaxResults, this value can be
     * used to retrieve the next page of results. This value is null when there are no
     * more results to return.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The IDs of the volumes.
     * Default: Describes all your volumes.
     */
    val volumeIds: List<String>? = builder.volumeIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeVolumeStatusRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVolumeStatusRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("volumeIds=$volumeIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (volumeIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeVolumeStatusRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (volumeIds != other.volumeIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeVolumeStatusRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeVolumeStatusRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The filters.
         * action.code - The action code for the event (for example,
         * enable-volume-io).
         * action.description - A description of the action.
         * action.event-id - The event ID associated with the action.
         * availability-zone - The Availability Zone of the instance.
         * event.description - A description of the event.
         * event.event-id - The event ID.
         * event.event-type - The event type (for io-enabled:
         * passed | failed; for io-performance:
         * io-performance:degraded | io-performance:severely-degraded |
         * io-performance:stalled).
         * event.not-after - The latest end time for the event.
         * event.not-before - The earliest start time for the event.
         * volume-status.details-name - The cause for
         * volume-status.status (io-enabled |
         * io-performance).
         * volume-status.details-status - The status of
         * volume-status.details-name (for io-enabled:
         * passed | failed; for io-performance:
         * normal | degraded | severely-degraded |
         * stalled).
         * volume-status.status - The status of the volume (ok |
         * impaired | warning | insufficient-data).
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of volume results returned by DescribeVolumeStatus in
         * paginated output. When this parameter is used, the request only returns
         * MaxResults results in a single page along with a NextToken
         * response element. The remaining results of the initial request can be seen by sending another
         * request with the returned NextToken value. This value can be between 5 and 1,000;
         * if MaxResults is given a value larger than 1,000, only 1,000 results are returned.
         * If this parameter is not used, then DescribeVolumeStatus returns all results. You
         * cannot specify this parameter and the volume IDs parameter in the same request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The NextToken value to include in a future DescribeVolumeStatus
         * request. When the results of the request exceed MaxResults, this value can be
         * used to retrieve the next page of results. This value is null when there are no
         * more results to return.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The IDs of the volumes.
         * Default: Describes all your volumes.
         */
        fun volumeIds(volumeIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The filters.
         * action.code - The action code for the event (for example,
         * enable-volume-io).
         * action.description - A description of the action.
         * action.event-id - The event ID associated with the action.
         * availability-zone - The Availability Zone of the instance.
         * event.description - A description of the event.
         * event.event-id - The event ID.
         * event.event-type - The event type (for io-enabled:
         * passed | failed; for io-performance:
         * io-performance:degraded | io-performance:severely-degraded |
         * io-performance:stalled).
         * event.not-after - The latest end time for the event.
         * event.not-before - The earliest start time for the event.
         * volume-status.details-name - The cause for
         * volume-status.status (io-enabled |
         * io-performance).
         * volume-status.details-status - The status of
         * volume-status.details-name (for io-enabled:
         * passed | failed; for io-performance:
         * normal | degraded | severely-degraded |
         * stalled).
         * volume-status.status - The status of the volume (ok |
         * impaired | warning | insufficient-data).
         */
        var filters: List<Filter>?
        /**
         * The maximum number of volume results returned by DescribeVolumeStatus in
         * paginated output. When this parameter is used, the request only returns
         * MaxResults results in a single page along with a NextToken
         * response element. The remaining results of the initial request can be seen by sending another
         * request with the returned NextToken value. This value can be between 5 and 1,000;
         * if MaxResults is given a value larger than 1,000, only 1,000 results are returned.
         * If this parameter is not used, then DescribeVolumeStatus returns all results. You
         * cannot specify this parameter and the volume IDs parameter in the same request.
         */
        var maxResults: Int?
        /**
         * The NextToken value to include in a future DescribeVolumeStatus
         * request. When the results of the request exceed MaxResults, this value can be
         * used to retrieve the next page of results. This value is null when there are no
         * more results to return.
         */
        var nextToken: String?
        /**
         * The IDs of the volumes.
         * Default: Describes all your volumes.
         */
        var volumeIds: List<String>?

        fun build(): DescribeVolumeStatusRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var volumeIds: List<String>? = null

        constructor(x: DescribeVolumeStatusRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.volumeIds = x.volumeIds
        }

        override fun build(): DescribeVolumeStatusRequest = DescribeVolumeStatusRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun volumeIds(volumeIds: List<String>): FluentBuilder = apply { this.volumeIds = volumeIds }
    }
}
