// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeVpcEndpointConnectionNotificationsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the notification.
     */
    val connectionNotificationId: String? = builder.connectionNotificationId
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * connection-notification-arn - The ARN of the SNS topic for the
     * notification.
     * connection-notification-id - The ID of the
     * notification.
     * connection-notification-state - The state of the notification
     * (Enabled | Disabled).
     * connection-notification-type - The type of notification
     * (Topic).
     * service-id - The ID of the endpoint service.
     * vpc-endpoint-id - The ID of the VPC endpoint.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining
     * results, make another request with the returned NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to request the next page of results.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeVpcEndpointConnectionNotificationsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVpcEndpointConnectionNotificationsRequest(")
        append("connectionNotificationId=$connectionNotificationId,")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionNotificationId?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeVpcEndpointConnectionNotificationsRequest

        if (connectionNotificationId != other.connectionNotificationId) return false
        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeVpcEndpointConnectionNotificationsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeVpcEndpointConnectionNotificationsRequest
        /**
         * The ID of the notification.
         */
        fun connectionNotificationId(connectionNotificationId: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * connection-notification-arn - The ARN of the SNS topic for the
         * notification.
         * connection-notification-id - The ID of the
         * notification.
         * connection-notification-state - The state of the notification
         * (Enabled | Disabled).
         * connection-notification-type - The type of notification
         * (Topic).
         * service-id - The ID of the endpoint service.
         * vpc-endpoint-id - The ID of the VPC endpoint.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another request with the returned NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to request the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the notification.
         */
        var connectionNotificationId: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * connection-notification-arn - The ARN of the SNS topic for the
         * notification.
         * connection-notification-id - The ID of the
         * notification.
         * connection-notification-state - The state of the notification
         * (Enabled | Disabled).
         * connection-notification-type - The type of notification
         * (Topic).
         * service-id - The ID of the endpoint service.
         * vpc-endpoint-id - The ID of the VPC endpoint.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another request with the returned NextToken value.
         */
        var maxResults: Int?
        /**
         * The token to request the next page of results.
         */
        var nextToken: String?

        fun build(): DescribeVpcEndpointConnectionNotificationsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var connectionNotificationId: String? = null
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: DescribeVpcEndpointConnectionNotificationsRequest) : this() {
            this.connectionNotificationId = x.connectionNotificationId
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): DescribeVpcEndpointConnectionNotificationsRequest = DescribeVpcEndpointConnectionNotificationsRequest(this)
        override fun connectionNotificationId(connectionNotificationId: String): FluentBuilder = apply { this.connectionNotificationId = connectionNotificationId }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
