// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeVpcEndpoints.
 */
class DescribeVpcEndpointsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * service-name - The name of the service.
     * vpc-id - The ID of the VPC in which the endpoint resides.
     * vpc-endpoint-id - The ID of the endpoint.
     * vpc-endpoint-state - The state of the endpoint
     * (pendingAcceptance | pending |
     * available | deleting | deleted |
     * rejected | failed).
     * vpc-endpoint-type - The type of VPC endpoint (Interface | Gateway | GatewayLoadBalancer).
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
     * Constraint: If the value is greater than 1,000, we return only 1,000 items.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of items to return. (You received this token from a prior call.)
     */
    val nextToken: String? = builder.nextToken
    /**
     * One or more endpoint IDs.
     */
    val vpcEndpointIds: List<String>? = builder.vpcEndpointIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeVpcEndpointsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVpcEndpointsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("vpcEndpointIds=$vpcEndpointIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeVpcEndpointsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (vpcEndpointIds != other.vpcEndpointIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeVpcEndpointsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeVpcEndpointsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * service-name - The name of the service.
         * vpc-id - The ID of the VPC in which the endpoint resides.
         * vpc-endpoint-id - The ID of the endpoint.
         * vpc-endpoint-state - The state of the endpoint
         * (pendingAcceptance | pending |
         * available | deleting | deleted |
         * rejected | failed).
         * vpc-endpoint-type - The type of VPC endpoint (Interface | Gateway | GatewayLoadBalancer).
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
         * Constraint: If the value is greater than 1,000, we return only 1,000 items.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of items to return. (You received this token from a prior call.)
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * One or more endpoint IDs.
         */
        fun vpcEndpointIds(vpcEndpointIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * service-name - The name of the service.
         * vpc-id - The ID of the VPC in which the endpoint resides.
         * vpc-endpoint-id - The ID of the endpoint.
         * vpc-endpoint-state - The state of the endpoint
         * (pendingAcceptance | pending |
         * available | deleting | deleted |
         * rejected | failed).
         * vpc-endpoint-type - The type of VPC endpoint (Interface | Gateway | GatewayLoadBalancer).
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
         * Constraint: If the value is greater than 1,000, we return only 1,000 items.
         */
        var maxResults: Int?
        /**
         * The token for the next set of items to return. (You received this token from a prior call.)
         */
        var nextToken: String?
        /**
         * One or more endpoint IDs.
         */
        var vpcEndpointIds: List<String>?

        fun build(): DescribeVpcEndpointsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var vpcEndpointIds: List<String>? = null

        constructor(x: DescribeVpcEndpointsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.vpcEndpointIds = x.vpcEndpointIds
        }

        override fun build(): DescribeVpcEndpointsRequest = DescribeVpcEndpointsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun vpcEndpointIds(vpcEndpointIds: List<String>): FluentBuilder = apply { this.vpcEndpointIds = vpcEndpointIds }
    }
}
