// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeVpcPeeringConnectionsRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more filters.
     * accepter-vpc-info.cidr-block - The IPv4 CIDR block of the accepter
     * VPC.
     * accepter-vpc-info.owner-id - The ID of the Amazon Web Services account that owns the
     * accepter VPC.
     * accepter-vpc-info.vpc-id - The ID of the accepter VPC.
     * expiration-time - The expiration date and time for the VPC peering
     * connection.
     * requester-vpc-info.cidr-block - The IPv4 CIDR block of the
     * requester's VPC.
     * requester-vpc-info.owner-id - The ID of the Amazon Web Services account that owns the
     * requester VPC.
     * requester-vpc-info.vpc-id - The ID of the requester VPC.
     * status-code - The status of the VPC peering connection
     * (pending-acceptance | failed |
     * expired | provisioning | active |
     * deleting | deleted |
     * rejected).
     * status-message - A message that provides more information about the status
     * of the VPC peering connection, if applicable.
     * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
     * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * vpc-peering-connection-id - The ID of the VPC peering connection.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call.
     * To retrieve the remaining results, make another call with the returned nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * One or more VPC peering connection IDs.
     * Default: Describes all your VPC peering connections.
     */
    val vpcPeeringConnectionIds: List<String>? = builder.vpcPeeringConnectionIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeVpcPeeringConnectionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVpcPeeringConnectionsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("vpcPeeringConnectionIds=$vpcPeeringConnectionIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeVpcPeeringConnectionsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (vpcPeeringConnectionIds != other.vpcPeeringConnectionIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeVpcPeeringConnectionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeVpcPeeringConnectionsRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more filters.
         * accepter-vpc-info.cidr-block - The IPv4 CIDR block of the accepter
         * VPC.
         * accepter-vpc-info.owner-id - The ID of the Amazon Web Services account that owns the
         * accepter VPC.
         * accepter-vpc-info.vpc-id - The ID of the accepter VPC.
         * expiration-time - The expiration date and time for the VPC peering
         * connection.
         * requester-vpc-info.cidr-block - The IPv4 CIDR block of the
         * requester's VPC.
         * requester-vpc-info.owner-id - The ID of the Amazon Web Services account that owns the
         * requester VPC.
         * requester-vpc-info.vpc-id - The ID of the requester VPC.
         * status-code - The status of the VPC peering connection
         * (pending-acceptance | failed |
         * expired | provisioning | active |
         * deleting | deleted |
         * rejected).
         * status-message - A message that provides more information about the status
         * of the VPC peering connection, if applicable.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * vpc-peering-connection-id - The ID of the VPC peering connection.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * One or more VPC peering connection IDs.
         * Default: Describes all your VPC peering connections.
         */
        fun vpcPeeringConnectionIds(vpcPeeringConnectionIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more filters.
         * accepter-vpc-info.cidr-block - The IPv4 CIDR block of the accepter
         * VPC.
         * accepter-vpc-info.owner-id - The ID of the Amazon Web Services account that owns the
         * accepter VPC.
         * accepter-vpc-info.vpc-id - The ID of the accepter VPC.
         * expiration-time - The expiration date and time for the VPC peering
         * connection.
         * requester-vpc-info.cidr-block - The IPv4 CIDR block of the
         * requester's VPC.
         * requester-vpc-info.owner-id - The ID of the Amazon Web Services account that owns the
         * requester VPC.
         * requester-vpc-info.vpc-id - The ID of the requester VPC.
         * status-code - The status of the VPC peering connection
         * (pending-acceptance | failed |
         * expired | provisioning | active |
         * deleting | deleted |
         * rejected).
         * status-message - A message that provides more information about the status
         * of the VPC peering connection, if applicable.
         * tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
         * For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
         * tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * vpc-peering-connection-id - The ID of the VPC peering connection.
         */
        var filters: List<Filter>?
        /**
         * The maximum number of results to return with a single call.
         * To retrieve the remaining results, make another call with the returned nextToken value.
         */
        var maxResults: Int?
        /**
         * The token for the next page of results.
         */
        var nextToken: String?
        /**
         * One or more VPC peering connection IDs.
         * Default: Describes all your VPC peering connections.
         */
        var vpcPeeringConnectionIds: List<String>?

        fun build(): DescribeVpcPeeringConnectionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var vpcPeeringConnectionIds: List<String>? = null

        constructor(x: DescribeVpcPeeringConnectionsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.vpcPeeringConnectionIds = x.vpcPeeringConnectionIds
        }

        override fun build(): DescribeVpcPeeringConnectionsRequest = DescribeVpcPeeringConnectionsRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun vpcPeeringConnectionIds(vpcPeeringConnectionIds: List<String>): FluentBuilder = apply { this.vpcPeeringConnectionIds = vpcPeeringConnectionIds }
    }
}
