// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the destination options for a flow log.
 */
class DestinationOptionsResponse private constructor(builder: BuilderImpl) {
    /**
     * The format for the flow log.
     */
    val fileFormat: DestinationFileFormat? = builder.fileFormat
    /**
     * Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3.
     */
    val hiveCompatiblePartitions: Boolean? = builder.hiveCompatiblePartitions
    /**
     * Indicates whether to partition the flow log per hour.
     */
    val perHourPartition: Boolean? = builder.perHourPartition

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DestinationOptionsResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationOptionsResponse(")
        append("fileFormat=$fileFormat,")
        append("hiveCompatiblePartitions=$hiveCompatiblePartitions,")
        append("perHourPartition=$perHourPartition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileFormat?.hashCode() ?: 0
        result = 31 * result + (hiveCompatiblePartitions?.hashCode() ?: 0)
        result = 31 * result + (perHourPartition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DestinationOptionsResponse

        if (fileFormat != other.fileFormat) return false
        if (hiveCompatiblePartitions != other.hiveCompatiblePartitions) return false
        if (perHourPartition != other.perHourPartition) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DestinationOptionsResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DestinationOptionsResponse
        /**
         * The format for the flow log.
         */
        fun fileFormat(fileFormat: DestinationFileFormat): FluentBuilder
        /**
         * Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3.
         */
        fun hiveCompatiblePartitions(hiveCompatiblePartitions: Boolean): FluentBuilder
        /**
         * Indicates whether to partition the flow log per hour.
         */
        fun perHourPartition(perHourPartition: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The format for the flow log.
         */
        var fileFormat: DestinationFileFormat?
        /**
         * Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3.
         */
        var hiveCompatiblePartitions: Boolean?
        /**
         * Indicates whether to partition the flow log per hour.
         */
        var perHourPartition: Boolean?

        fun build(): DestinationOptionsResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fileFormat: DestinationFileFormat? = null
        override var hiveCompatiblePartitions: Boolean? = null
        override var perHourPartition: Boolean? = null

        constructor(x: DestinationOptionsResponse) : this() {
            this.fileFormat = x.fileFormat
            this.hiveCompatiblePartitions = x.hiveCompatiblePartitions
            this.perHourPartition = x.perHourPartition
        }

        override fun build(): DestinationOptionsResponse = DestinationOptionsResponse(this)
        override fun fileFormat(fileFormat: DestinationFileFormat): FluentBuilder = apply { this.fileFormat = fileFormat }
        override fun hiveCompatiblePartitions(hiveCompatiblePartitions: Boolean): FluentBuilder = apply { this.hiveCompatiblePartitions = hiveCompatiblePartitions }
        override fun perHourPartition(perHourPartition: Boolean): FluentBuilder = apply { this.perHourPartition = perHourPartition }
    }
}
